/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.ObjectBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.StreamFromBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class MultipleObjectsBundle
implements ObjectBundle {
    private static final Logging LOG = Logging.getLogger(MultipleObjectsBundle.class);
    private BundleMeta meta = new BundleMeta();
    private List<List<?>> columns = new ArrayList();
    private ArrayDBIDs ids;

    @Override
    public BundleMeta meta() {
        return this.meta;
    }

    @Override
    public SimpleTypeInformation<?> meta(int i) {
        return (SimpleTypeInformation)this.meta.get(i);
    }

    @Override
    public int metaLength() {
        return this.meta.size();
    }

    @Override
    public Object data(int onum, int rnum) {
        return this.columns.get(rnum).get(onum);
    }

    @Override
    public boolean assignDBID(int onum, DBIDVar var) {
        if (this.ids == null) {
            var.unset();
            return false;
        }
        this.ids.assignVar(onum, var);
        return true;
    }

    @Override
    public int dataLength() {
        return this.ids != null ? this.ids.size() : (this.columns.isEmpty() ? 0 : this.columns.get(0).size());
    }

    public void appendSimple(Object ... data) {
        if (data.length != this.meta.size()) {
            throw new AbortException("Invalid number of attributes in 'append'.");
        }
        for (int i = 0; i < data.length; ++i) {
            List<?> col = this.columns.get(i);
            col.add(data[i]);
        }
    }

    public MultipleObjectsBundle appendColumn(SimpleTypeInformation<?> type, List<?> data) {
        this.meta.add(type);
        this.columns.add(data);
        return this;
    }

    public void setDBIDs(ArrayDBIDs ids) {
        this.ids = ids;
    }

    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public List<?> getColumn(int i) {
        return this.columns.get(i);
    }

    public static <V> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V> type, List<? extends V> data) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        bundle.appendColumn(type, data);
        return bundle;
    }

    public static <V1, V2> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V1> type1, List<? extends V1> data1, SimpleTypeInformation<? super V2> type2, List<? extends V2> data2) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        bundle.appendColumn(type1, data1);
        bundle.appendColumn(type2, data2);
        return bundle;
    }

    public static <V1, V2, V3> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V1> type1, List<? extends V1> data1, SimpleTypeInformation<? super V2> type2, List<? extends V2> data2, SimpleTypeInformation<? super V3> type3, List<? extends V3> data3) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        bundle.appendColumn(type1, data1);
        bundle.appendColumn(type2, data2);
        bundle.appendColumn(type3, data3);
        return bundle;
    }

    public BundleStreamSource asStream() {
        return new StreamFromBundle(this);
    }

    public static MultipleObjectsBundle fromStream(BundleStreamSource source) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        boolean stop = false;
        DBIDVar var = null;
        DBIDs ids = null;
        int size = 0;
        block5: while (!stop) {
            BundleStreamSource.Event ev = source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    stop = true;
                    continue block5;
                }
                case META_CHANGED: {
                    int i;
                    BundleMeta smeta = source.getMeta();
                    bundle.meta = new BundleMeta();
                    for (i = 0; i < bundle.columns.size(); ++i) {
                        bundle.meta.add(smeta.get(i));
                    }
                    for (i = bundle.metaLength(); i < smeta.size(); ++i) {
                        ArrayList data = new ArrayList(bundle.dataLength() + 1);
                        bundle.appendColumn((SimpleTypeInformation)smeta.get(i), data);
                    }
                    if (var != null || !source.hasDBIDs()) continue block5;
                    var = DBIDUtil.newVar();
                    ids = DBIDUtil.newArray();
                    continue block5;
                }
                case NEXT_OBJECT: {
                    int i;
                    if (var != null && source.assignDBID(var)) {
                        ids.add(var);
                    }
                    for (i = 0; i < bundle.metaLength(); ++i) {
                        List<?> col = bundle.columns.get(i);
                        col.add(source.data(i));
                    }
                    ++size;
                    continue block5;
                }
            }
            LoggingUtil.warning("Unknown event: " + (Object)((Object)ev));
        }
        if (ids != null) {
            if (size != ids.size()) {
                LOG.warning("Not every object had an DBID - discarding DBIDs: " + size + " != " + ids.size());
            } else {
                bundle.setDBIDs((ArrayDBIDs)ids);
            }
        }
        return bundle;
    }

    public Object[] getRow(int row) {
        Object[] ret = new Object[this.columns.size()];
        for (int c = 0; c < this.columns.size(); ++c) {
            ret[c] = this.data(row, c);
        }
        return ret;
    }
}

