/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.ObjectBundle;
import java.util.ArrayList;
import java.util.List;

public class SingleObjectBundle
implements ObjectBundle {
    private BundleMeta meta;
    private List<Object> contents;
    private DBID id;

    public SingleObjectBundle() {
        this(new BundleMeta(), new ArrayList<Object>(5));
    }

    public SingleObjectBundle(BundleMeta meta, List<Object> contents) {
        this.meta = meta;
        this.contents = contents;
        assert (meta.size() == contents.size());
    }

    public SingleObjectBundle(BundleMeta meta, DBID id, List<Object> contents) {
        this.meta = meta;
        this.id = id;
        this.contents = contents;
        assert (meta.size() == contents.size());
    }

    @Override
    public BundleMeta meta() {
        return this.meta;
    }

    @Override
    public SimpleTypeInformation<?> meta(int i) {
        return (SimpleTypeInformation)this.meta.get(i);
    }

    @Override
    public int metaLength() {
        return this.meta.size();
    }

    public Object data(int rnum) {
        return this.contents.get(rnum);
    }

    @Override
    public int dataLength() {
        return 1;
    }

    @Override
    public Object data(int onum, int rnum) {
        if (onum != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.contents.get(rnum);
    }

    @Override
    public boolean assignDBID(int onum, DBIDVar var) {
        if (this.id == null) {
            var.unset();
            return false;
        }
        var.set(this.id);
        return true;
    }

    public void append(SimpleTypeInformation<?> meta, Object data) {
        this.meta.add(meta);
        this.contents.add(data);
    }
}

