/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;

public abstract class AbstractStreamConversionFilter<I, O>
extends AbstractStreamFilter {
    BundleMeta meta;
    int column = -1;

    @Override
    public BundleMeta getMeta() {
        return this.meta;
    }

    @Override
    public Object data(int rnum) {
        if (rnum != this.column) {
            return this.source.data(rnum);
        }
        Object obj = this.source.data(rnum);
        return this.filterSingleObject(obj);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        BundleStreamSource.Event ev = this.source.nextEvent();
        if (ev == BundleStreamSource.Event.META_CHANGED) {
            if (this.meta == null) {
                this.meta = new BundleMeta();
            }
            BundleMeta origmeta = this.source.getMeta();
            for (int i = this.meta.size(); i < origmeta.size(); ++i) {
                if (this.column < 0) {
                    SimpleTypeInformation type = (SimpleTypeInformation)origmeta.get(i);
                    if (this.getInputTypeRestriction().isAssignableFromType(type)) {
                        SimpleTypeInformation castType = type;
                        this.meta.add(this.convertedType(castType));
                        this.column = i;
                        continue;
                    }
                }
                this.meta.add(origmeta.get(i));
            }
        }
        return ev;
    }

    protected abstract O filterSingleObject(I var1);

    protected abstract TypeInformation getInputTypeRestriction();

    protected abstract SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<I> var1);
}

