/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.lang.reflect.Field;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static <V extends NumberVector> NumberVector.Factory<V> guessFactory(SimpleTypeInformation<V> in) {
        NumberVector.Factory factory = null;
        if (in instanceof VectorTypeInformation) {
            factory = (NumberVector.Factory)((VectorTypeInformation)in).getFactory();
        }
        if (factory == null) {
            try {
                Field f = in.getRestrictionClass().getField("FACTORY");
                factory = (NumberVector.Factory)f.get(null);
            }
            catch (Exception e) {
                LoggingUtil.warning("Cannot determine factory for type " + in.getRestrictionClass(), e);
            }
        }
        return factory;
    }

    public static int findLabelColumn(MultipleObjectsBundle bundle) {
        for (int i = 0; i < bundle.metaLength(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType(bundle.meta(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findLabelColumn(BundleMeta meta) {
        for (int i = 0; i < meta.size(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)meta.get(i))) continue;
            return i;
        }
        return -1;
    }
}

