/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.FilterNoMissingValuesFilter", "de.lmu.ifi.dbs.elki.datasource.filter.NoMissingValuesFilter"})
public class NoMissingValuesFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(NoMissingValuesFilter.class);
    private int cols = 0;

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.cols = this.source.getMeta().size();
                    return ev;
                }
                case NEXT_OBJECT: {
                    boolean good = true;
                    for (int j = 0; j < this.cols; ++j) {
                        if (this.source.data(j) != null) continue;
                        good = false;
                        break;
                    }
                    if (!good) continue block5;
                    return ev;
                }
            }
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (LOG.isDebugging()) {
            LOG.debug("Filtering the data set");
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int j = 0; j < objects.metaLength(); ++j) {
            bundle.appendColumn(objects.meta(j), new ArrayList());
        }
        for (int i = 0; i < objects.dataLength(); ++i) {
            boolean good = true;
            for (int j = 0; j < objects.metaLength(); ++j) {
                if (objects.data(i, j) != null) continue;
                good = false;
                break;
            }
            if (!good) continue;
            bundle.appendSimple(objects.getRow(i));
        }
        return bundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NoMissingValuesFilter makeInstance() {
            return new NoMissingValuesFilter();
        }
    }
}

