/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ReplaceNaNWithRandomFilter"})
public class ReplaceNaNWithRandomFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(ReplaceNaNWithRandomFilter.class);
    private NumberVector.Factory<?>[] densecols = null;
    private Distribution dist;
    private ArrayList<Object> rows = new ArrayList();

    public ReplaceNaNWithRandomFilter(Distribution dist) {
        this.dist = dist;
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int rnum) {
        return this.rows.get(rnum);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.updateMeta(this.source.getMeta());
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.densecols == null) {
                        this.updateMeta(this.source.getMeta());
                    }
                    this.rows.clear();
                    for (int j = 0; j < this.densecols.length; ++j) {
                        Object o = this.source.data(j);
                        if (this.densecols[j] != null) {
                            NumberVector v = (NumberVector)o;
                            if (v == null) continue;
                            double[] ro = null;
                            for (int i = 0; i < v.getDimensionality(); ++i) {
                                if (!Double.isNaN(v.doubleValue(i))) continue;
                                ro = ro != null ? ro : v.toArray();
                                ro[i] = this.dist.nextRandom();
                            }
                            if (ro != null) {
                                o = this.densecols[j].newNumberVector(ro);
                            }
                        }
                        this.rows.add(o);
                    }
                    return ev;
                }
            }
        }
    }

    private void updateMeta(BundleMeta meta) {
        int cols = meta.size();
        this.densecols = new NumberVector.Factory[cols];
        for (int i = 0; i < cols; ++i) {
            if (TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) {
                throw new AbortException("Filtering sparse vectors is not yet supported by this filter. Please contribute.");
            }
            if (!TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) continue;
            VectorFieldTypeInformation vmeta = (VectorFieldTypeInformation)meta.get(i);
            this.densecols[i] = (NumberVector.Factory)vmeta.getFactory();
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Removing records with NaN values.");
        }
        this.updateMeta(objects.meta());
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int j = 0; j < objects.metaLength(); ++j) {
            bundle.appendColumn(objects.meta(j), new ArrayList());
        }
        for (int i = 0; i < objects.dataLength(); ++i) {
            Object[] row = objects.getRow(i);
            for (int j = 0; j < this.densecols.length; ++j) {
                if (this.densecols[j] == null) continue;
                NumberVector v = (NumberVector)row[j];
                double[] ro = null;
                if (v != null) {
                    for (int d = 0; d < v.getDimensionality(); ++d) {
                        if (!Double.isNaN(v.doubleValue(d))) continue;
                        ro = ro != null ? ro : v.toArray();
                        ro[d] = this.dist.nextRandom();
                    }
                }
                row[j] = this.densecols[j].newNumberVector(ro);
            }
            bundle.appendSimple(row);
        }
        return bundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID REPLACEMENT_DISTRIBUTION = new OptionID("nanfilter.replacement", "Distribution to sample replacement values from.");
        private Distribution dist;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter distP = new ObjectParameter(REPLACEMENT_DISTRIBUTION, Distribution.class);
            if (config.grab(distP)) {
                this.dist = (Distribution)distP.instantiateClass(config);
            }
        }

        @Override
        protected ReplaceNaNWithRandomFilter makeInstance() {
            return new ReplaceNaNWithRandomFilter(this.dist);
        }
    }
}

