/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class VectorDimensionalityFilter<V extends NumberVector>
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(VectorDimensionalityFilter.class);
    BundleMeta meta;
    int column = -1;
    int dim = -1;

    public VectorDimensionalityFilter(int dim) {
        this.dim = dim;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.updateMeta();
        }
        return this.source.getMeta();
    }

    @Override
    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.meta = null;
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.meta == null) {
                        this.updateMeta();
                    }
                    if (this.column >= 0 && this.dim >= 0) {
                        NumberVector vec = (NumberVector)this.source.data(this.column);
                        if (vec == null) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            LOG.veryverbose("Skipping null vector.");
                            continue block5;
                        }
                        if (vec.getDimensionality() != this.dim) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            StringBuilder buf = new StringBuilder(1000).append("Skipping vector of wrong dimensionality ").append(vec.getDimensionality()).append(':');
                            for (int i = 0; i < this.meta.size(); ++i) {
                                buf.append(' ').append(this.source.data(i));
                            }
                            LOG.veryverbose(buf.toString());
                            continue block5;
                        }
                    }
                    return ev;
                }
            }
        }
    }

    private void updateMeta() {
        this.meta = new BundleMeta();
        BundleMeta origmeta = this.source.getMeta();
        for (int i = 0; i < origmeta.size(); ++i) {
            SimpleTypeInformation type = (SimpleTypeInformation)origmeta.get(i);
            if (this.column < 0 && TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType(type)) {
                VectorTypeInformation castType;
                if (type instanceof VectorFieldTypeInformation) {
                    castType = (VectorFieldTypeInformation)type;
                    if (this.dim != -1 && castType.mindim() > this.dim) {
                        throw new AbortException("Would filter all vectors: minimum dimensionality " + castType.mindim() + " > desired dimensionality " + this.dim);
                    }
                    if (this.dim != -1 && castType.maxdim() < this.dim) {
                        throw new AbortException("Would filter all vectors: maximum dimensionality " + castType.maxdim() + " < desired dimensionality " + this.dim);
                    }
                    if (this.dim == -1) {
                        this.dim = castType.mindim();
                    }
                    if (castType.mindim() == castType.maxdim()) {
                        this.meta.add(castType);
                        this.column = i;
                        continue;
                    }
                }
                castType = (VectorTypeInformation)type;
                if (this.dim != -1) {
                    this.meta.add(new VectorFieldTypeInformation(FilterUtil.guessFactory(castType), this.dim, this.dim, castType.getSerializer()));
                } else {
                    LOG.warning("No dimensionality yet for column " + i);
                    this.meta.add(castType);
                }
                this.column = i;
                continue;
            }
            this.meta.add(type);
        }
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIM_P = new OptionID("filter.dim", "Dimensionality of vectors to retain.");
        int dim = -1;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter dimP = (IntParameter)((IntParameter)new IntParameter(DIM_P).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            this.dim = config.grab(dimP) ? dimP.intValue() : -1;
        }

        @Override
        protected VectorDimensionalityFilter<V> makeInstance() {
            return new VectorDimensionalityFilter(this.dim);
        }
    }
}

