/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise.AttributeWiseCDFNormalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.BetaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jafama.FastMath;

public class AttributeWiseBetaNormalization<V extends NumberVector>
extends AttributeWiseCDFNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseBetaNormalization.class);
    protected NumberVector.Factory<V> factory;
    protected double alpha = 0.01;

    public AttributeWiseBetaNormalization(List<DistributionEstimator<?>> estimators, double alpha) {
        super(estimators);
        this.alpha = alpha;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation<?> type = objects.meta(r);
            List<?> column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(type)) continue;
            List<?> castColumn = column;
            VectorFieldTypeInformation castType = (VectorFieldTypeInformation)type;
            this.factory = FilterUtil.guessFactory(castType);
            int dim = castType.getDimensionality();
            this.dists = new ArrayList(dim);
            double[] test = new double[castColumn.size()];
            AttributeWiseCDFNormalization.Adapter adapter = new AttributeWiseCDFNormalization.Adapter();
            for (int d = 0; d < dim; ++d) {
                adapter.dim = d;
                Distribution dist = this.findBestFit(castColumn, adapter, d, test);
                if (LOG.isVerbose()) {
                    LOG.verbose("Best fit for dimension " + d + ": " + dist.toString());
                }
                this.dists.add(dist);
            }
            double p = FastMath.pow(this.alpha, -1.0 / FastMath.sqrt(dim));
            BetaDistribution beta = new BetaDistribution(p, p);
            double[] buf = new double[dim];
            for (int i = 0; i < objects.dataLength(); ++i) {
                NumberVector obj = (NumberVector)castColumn.get(i);
                for (int d = 0; d < dim; ++d) {
                    buf[d] = beta.quantile(((Distribution)this.dists.get(d)).cdf(obj.doubleValue(d)));
                }
                castColumn.set(i, this.factory.newNumberVector(buf));
            }
        }
        return objects;
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        throw new NotImplementedException();
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        throw new NotImplementedException();
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DISTRIBUTIONS_ID = AttributeWiseCDFNormalization.Parameterizer.DISTRIBUTIONS_ID;
        public static final OptionID ALPHA_ID = new OptionID("normalize.beta.alpha", "Alpha parameter to control the shape of the output distribution.");
        private List<DistributionEstimator<?>> estimators;
        private double alpha;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter alphaP;
            super.makeOptions(config);
            ObjectListParameter estP = new ObjectListParameter(DISTRIBUTIONS_ID, DistributionEstimator.class);
            estP.setDefaultValue(Arrays.asList(BestFitEstimator.class));
            if (config.grab(estP)) {
                this.estimators = estP.instantiateClasses(config);
            }
            if (config.grab(alphaP = new DoubleParameter(ALPHA_ID, 0.1))) {
                this.alpha = alphaP.doubleValue();
            }
        }

        @Override
        protected AttributeWiseBetaNormalization<V> makeInstance() {
            return new AttributeWiseBetaNormalization(this.estimators, this.alpha);
        }
    }
}

