/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;

public class AttributeWiseMeanNormalization<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMeanNormalization.class);
    private double[] mean = null;
    double[] sums = null;
    int c = 0;

    public AttributeWiseMeanNormalization(double[] mean) {
        this.mean = mean;
    }

    public AttributeWiseMeanNormalization() {
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return this.mean == null || this.mean.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        if (this.sums == null || this.sums.length == 0) {
            this.sums = new double[featureVector.getDimensionality()];
        }
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            int n = d;
            this.sums[n] = this.sums[n] + featureVector.doubleValue(d);
        }
        ++this.c;
    }

    @Override
    protected void prepareComplete() {
        StringBuilder buf = LOG.isVerbose() ? new StringBuilder(200) : null;
        int dimensionality = this.sums.length;
        this.mean = new double[dimensionality];
        if (buf != null) {
            buf.append("Normalization parameters: ");
        }
        for (int d = 0; d < dimensionality; ++d) {
            this.mean[d] = this.sums[d] / (double)this.c;
            if (buf == null) continue;
            buf.append(" m: ").append(this.mean[d]);
        }
        this.sums = null;
        if (buf != null) {
            LOG.debugFine(buf.toString());
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.normalize(d, featureVector.doubleValue(d));
        }
        return this.factory.newNumberVector(values);
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.mean.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.mean.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.restore(d, featureVector.doubleValue(d));
        }
        return this.factory.newNumberVector(values);
    }

    private double normalize(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return val / this.mean[d];
    }

    private double restore(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return val * this.mean[d];
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] coeff = linearEquationSystem.getCoefficents();
        double[] rhs = linearEquationSystem.getRHS();
        int[] row = linearEquationSystem.getRowPermutations();
        int[] col = linearEquationSystem.getColumnPermutations();
        for (int r = 0; r < coeff.length; ++r) {
            double[] coeff_r = coeff[row[r]];
            double sum = 0.0;
            for (int c = 0; c < coeff_r.length; ++c) {
                int n = col[c];
                double d = coeff_r[n] / this.mean[c];
                coeff_r[n] = d;
                sum += d;
            }
            int n = row[r];
            rhs[n] = rhs[n] + sum;
        }
        return new LinearEquationSystem(coeff, rhs, row, col);
    }

    @Override
    public String toString() {
        return new StringBuilder(200).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization means: ").append(FormatUtil.format(this.mean)).toString();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }
}

