/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseMinMaxNormalization", "de.lmu.ifi.dbs.elki.datasource.filter.AttributeWiseMinMaxNormalization"})
@Priority(value=200)
public class AttributeWiseMinMaxNormalization<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMinMaxNormalization.class);
    private double[] maxima;
    private double[] minima;
    private static final double[] EMPTY_ARRAY = new double[0];

    public AttributeWiseMinMaxNormalization() {
        this(EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public AttributeWiseMinMaxNormalization(double[] minima, double[] maxima) {
        this.minima = minima != null ? minima : EMPTY_ARRAY;
        this.maxima = maxima != null ? maxima : EMPTY_ARRAY;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return this.minima.length == 0 || this.maxima.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        if (this.minima.length == 0 || this.maxima.length == 0) {
            int dimensionality = featureVector.getDimensionality();
            this.minima = new double[dimensionality];
            this.maxima = new double[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                this.maxima[i] = -1.7976931348623157E308;
                this.minima[i] = Double.MAX_VALUE;
            }
        }
        if (this.minima.length != featureVector.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors differ in length.");
        }
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            double val = featureVector.doubleValue(d);
            if (val < Double.POSITIVE_INFINITY && val > this.maxima[d]) {
                this.maxima[d] = val;
            }
            if (!(val > Double.NEGATIVE_INFINITY) || !(val < this.minima[d])) continue;
            this.minima[d] = val;
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        if (this.minima.length != featureVector.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors and given Minima/Maxima differ in length.");
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = (featureVector.doubleValue(d) - this.minima[d]) / this.factor(d);
        }
        return this.factory.newNumberVector(values);
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.maxima.length || featureVector.getDimensionality() != this.minima.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.maxima.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = featureVector.doubleValue(d) * this.factor(d) + this.minima[d];
        }
        return this.factory.newNumberVector(values);
    }

    private double factor(int dimension) {
        return this.maxima[dimension] > this.minima[dimension] ? this.maxima[dimension] - this.minima[dimension] : (this.maxima[dimension] > 0.0 ? this.maxima[dimension] : 1.0);
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] coeff = linearEquationSystem.getCoefficents();
        double[] rhs = linearEquationSystem.getRHS();
        int[] row = linearEquationSystem.getRowPermutations();
        int[] col = linearEquationSystem.getColumnPermutations();
        for (int r = 0; r < coeff.length; ++r) {
            double[] coeff_r = coeff[row[r]];
            double sum = 0.0;
            for (int c = 0; c < coeff_r.length; ++c) {
                int n = col[c];
                double d = coeff_r[n] / this.factor(c);
                coeff_r[n] = d;
                sum += this.minima[c] * d;
            }
            int n = row[r];
            rhs[n] = rhs[n] + sum;
        }
        return new LinearEquationSystem(coeff, rhs, row, col);
    }

    @Override
    public String toString() {
        return new StringBuilder(1000).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization minima: ").append(FormatUtil.format(this.minima)).append('\n').append("normalization maxima: ").append(FormatUtil.format(this.maxima)).toString();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    static /* synthetic */ double[] access$000() {
        return EMPTY_ARRAY;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MINIMA_ID = new OptionID("normalize.min", "a comma separated concatenation of the minimum values in each dimension that are mapped to 0. If no value is specified, the minimum value of the attribute range in this dimension will be taken.");
        public static final OptionID MAXIMA_ID = new OptionID("normalize.max", "a comma separated concatenation of the maximum values in each dimension that are mapped to 1. If no value is specified, the maximum value of the attribute range in this dimension will be taken.");
        private double[] maxima = AttributeWiseMinMaxNormalization.access$000();
        private double[] minima = AttributeWiseMinMaxNormalization.access$000();

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleListParameter maximaP;
            super.makeOptions(config);
            DoubleListParameter minimaP = (DoubleListParameter)new DoubleListParameter(MINIMA_ID).setOptional(true);
            if (config.grab(minimaP)) {
                this.minima = (double[])((double[])minimaP.getValue()).clone();
            }
            if (config.grab(maximaP = (DoubleListParameter)new DoubleListParameter(MAXIMA_ID).setOptional(!minimaP.isDefined()))) {
                this.maxima = (double[])((double[])maximaP.getValue()).clone();
            }
            if (this.minima != null && this.maxima != null && this.minima.length != this.maxima.length) {
                config.reportError(new WrongParameterValueException(minimaP, "and", maximaP, "must have the same number of values."));
            }
        }

        @Override
        protected AttributeWiseMinMaxNormalization<V> makeInstance() {
            return new AttributeWiseMinMaxNormalization(this.minima, this.maxima);
        }
    }
}

