/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseVarianceNormalization", "z", "de.lmu.ifi.dbs.elki.datasource.filter.AttributeWiseVarianceNormalization"})
@Priority(value=200)
public class AttributeWiseVarianceNormalization<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseVarianceNormalization.class);
    private double[] mean;
    private double[] stddev;
    MeanVariance[] mvs = null;

    public AttributeWiseVarianceNormalization() {
    }

    public AttributeWiseVarianceNormalization(double[] mean, double[] stddev) {
        this.mean = mean;
        this.stddev = stddev;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return this.mean == null || this.stddev == null || this.mean.length == 0 || this.stddev.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        if (this.mvs == null || this.mvs.length == 0) {
            this.mvs = MeanVariance.newArray(featureVector.getDimensionality());
        }
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            double v = featureVector.doubleValue(d);
            if (!(v > Double.NEGATIVE_INFINITY) || !(v < Double.POSITIVE_INFINITY)) continue;
            this.mvs[d].put(v);
        }
    }

    @Override
    protected void prepareComplete() {
        StringBuilder buf = LOG.isVerbose() ? new StringBuilder(300) : null;
        int dimensionality = this.mvs.length;
        this.mean = new double[dimensionality];
        this.stddev = new double[dimensionality];
        if (buf != null) {
            buf.append("Normalization parameters: ");
        }
        for (int d = 0; d < dimensionality; ++d) {
            this.mean[d] = this.mvs[d].getMean();
            this.stddev[d] = this.mvs[d].getNaiveStddev();
            double d2 = this.stddev[d] = this.stddev[d] > Double.MIN_NORMAL ? this.stddev[d] : 1.0;
            if (buf == null) continue;
            buf.append(" m: ").append(this.mean[d]).append(" v: ").append(this.stddev[d]);
        }
        this.mvs = null;
        if (buf != null) {
            LOG.debugFine(buf.toString());
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.normalize(d, featureVector.doubleValue(d));
        }
        return this.factory.newNumberVector(values);
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.mean.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.mean.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.restore(d, featureVector.doubleValue(d));
        }
        return this.factory.newNumberVector(values);
    }

    private double normalize(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return (val - this.mean[d]) / this.stddev[d];
    }

    private double restore(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return val * this.stddev[d] + this.mean[d];
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] coeff = linearEquationSystem.getCoefficents();
        double[] rhs = linearEquationSystem.getRHS();
        int[] row = linearEquationSystem.getRowPermutations();
        int[] col = linearEquationSystem.getColumnPermutations();
        for (int r = 0; r < coeff.length; ++r) {
            double[] coeff_r = coeff[row[r]];
            double sum = 0.0;
            for (int c = 0; c < coeff_r.length; ++c) {
                int n = col[c];
                double d = coeff_r[n] / this.stddev[c];
                coeff_r[n] = d;
                sum += this.mean[c] * d;
            }
            int n = row[r];
            rhs[n] = rhs[n] + sum;
        }
        return new LinearEquationSystem(coeff, rhs, row, col);
    }

    @Override
    public String toString() {
        return new StringBuilder(200).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization means: ").append(FormatUtil.format(this.mean)).append('\n').append("normalization stddevs: ").append(FormatUtil.format(this.stddev)).toString();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MEAN_ID = new OptionID("normalize.mean", "a comma separated concatenation of the mean values in each dimension that are mapped to 0. If no value is specified, the mean value of the attribute range in this dimension will be taken.");
        public static final OptionID STDDEV_ID = new OptionID("normalize.stddev", "a comma separated concatenation of the standard deviations in each dimension that are scaled to 1. If no value is specified, the standard deviation of the attribute range in this dimension will be taken.");
        private double[] mean = new double[0];
        private double[] stddev = new double[0];

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleListParameter stddevP;
            super.makeOptions(config);
            DoubleListParameter meanP = (DoubleListParameter)new DoubleListParameter(MEAN_ID).setOptional(true);
            if (config.grab(meanP)) {
                this.mean = (double[])((double[])meanP.getValue()).clone();
            }
            if (config.grab(stddevP = (DoubleListParameter)new DoubleListParameter(STDDEV_ID).setOptional(!meanP.isDefined()))) {
                for (double d : this.stddev = (double[])((double[])stddevP.getValue()).clone()) {
                    if (d != 0.0) continue;
                    config.reportError(new WrongParameterValueException(stddevP, stddevP.getValueAsString(), "Standard deviations must not be 0."));
                }
            }
            if (this.mean != null && this.stddev != null && this.mean.length != this.stddev.length) {
                config.reportError(new WrongParameterValueException(meanP, "and", stddevP, "must have the same number of values."));
            }
        }

        @Override
        protected AttributeWiseVarianceNormalization<V> makeInstance() {
            return new AttributeWiseVarianceNormalization(this.mean, this.stddev);
        }
    }
}

