/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.InverseDocumentFrequencyNormalization", "de.lmu.ifi.dbs.elki.datasource.filter.InverseDocumentFrequencyNormalization"})
public class InverseDocumentFrequencyNormalization<V extends SparseNumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(InverseDocumentFrequencyNormalization.class);
    Int2DoubleOpenHashMap idf = new Int2DoubleOpenHashMap();
    int objcnt = 0;

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        if (this.idf.size() > 0) {
            throw new UnsupportedOperationException("This normalization may only be used once!");
        }
        this.objcnt = 0;
        return true;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        int it = featureVector.iter();
        while (featureVector.iterValid(it)) {
            if (featureVector.iterDoubleValue(it) >= 0.0) {
                int dim = featureVector.iterDim(it);
                this.idf.put(dim, this.idf.get(dim) + 1.0);
            }
            it = featureVector.iterAdvance(it);
        }
        ++this.objcnt;
    }

    @Override
    protected void prepareComplete() {
        double dbsize = this.objcnt;
        ObjectIterator<Int2DoubleMap.Entry> iter = this.idf.int2DoubleEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2DoubleMap.Entry entry = (Int2DoubleMap.Entry)iter.next();
            entry.setValue(FastMath.log(dbsize / entry.getDoubleValue()));
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        Int2DoubleOpenHashMap vals = new Int2DoubleOpenHashMap();
        int it = featureVector.iter();
        while (featureVector.iterValid(it)) {
            int dim = featureVector.iterDim(it);
            vals.put(dim, featureVector.iterDoubleValue(it) * this.idf.get(dim));
            it = featureVector.iterAdvance(it);
        }
        return ((SparseNumberVector.Factory)this.factory).newNumberVector(vals, featureVector.getDimensionality());
    }

    @Override
    public V restore(V featureVector) {
        Int2DoubleOpenHashMap vals = new Int2DoubleOpenHashMap();
        int it = featureVector.iter();
        while (featureVector.iterValid(it)) {
            int dim = featureVector.iterDim(it);
            vals.put(dim, featureVector.iterDoubleValue(it) / this.idf.get(dim));
            it = featureVector.iterAdvance(it);
        }
        return ((SparseNumberVector.Factory)this.factory).newNumberVector(vals, featureVector.getDimensionality());
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

