/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class HellingerHistogramNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    public static final HellingerHistogramNormalization<NumberVector> STATIC = new HellingerHistogramNormalization();

    @Override
    protected V filterSingleObject(V featureVector) {
        double v;
        int d;
        double[] data = new double[featureVector.getDimensionality()];
        double sum = 0.0;
        for (d = 0; d < data.length; ++d) {
            v = featureVector.doubleValue(d);
            data[d] = v > 0.0 ? v : -v;
            sum += data[d];
        }
        if (sum > 0.0) {
            for (d = 0; d < data.length; ++d) {
                v = data[d];
                data[d] = v > 0.0 ? FastMath.sqrt(v / sum) * MathUtil.SQRTHALF : 0.0;
            }
        }
        return this.factory.newNumberVector(data);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HellingerHistogramNormalization<NumberVector> makeInstance() {
            return STATIC;
        }
    }
}

