/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;
import net.jafama.FastMath;

public class InstanceLogRankNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    private static final double CENTER = FastMath.log1p(0.5) * MathUtil.ONE_BY_LOG2;

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] raw = featureVector.toArray();
        double[] tmp = (double[])raw.clone();
        Arrays.sort(tmp);
        double scale = 0.5 / (double)(raw.length - 1);
        for (int i = 0; i < raw.length; ++i) {
            int first;
            double v = raw[i];
            if (v != v) {
                raw[i] = CENTER;
                continue;
            }
            int last = first + 1;
            assert (first >= 0);
            for (first = Arrays.binarySearch(tmp, v); first > 0 && tmp[first - 1] >= v; --first) {
            }
            while (last < tmp.length && tmp[last] <= v) {
                ++last;
            }
            raw[i] = FastMath.log1p((double)(first + last - 1) * scale) * MathUtil.ONE_BY_LOG2;
        }
        return this.factory.newNumberVector(raw);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected InstanceLogRankNormalization<NumberVector> makeInstance() {
            return new InstanceLogRankNormalization<NumberVector>();
        }
    }
}

