/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.LengthNormalization"})
public class LengthNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    Norm<? super V> norm;

    public LengthNormalization(Norm<? super V> norm) {
        this.norm = norm;
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double d = this.norm.norm(featureVector);
        return this.factory.newNumberVector(VMath.timesEquals(featureVector.toArray(), d > 0.0 ? 1.0 / d : 1.0));
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID NORM_ID = new OptionID("normalization.norm", "Norm (length function) to use for computing the vector length.");
        Norm<? super V> norm;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter normP = new ObjectParameter(NORM_ID, (Class<?>)Norm.class, EuclideanDistanceFunction.class);
            if (config.grab(normP)) {
                this.norm = (Norm)normP.instantiateClass(config);
            }
        }

        @Override
        protected LengthNormalization<V> makeInstance() {
            return new LengthNormalization<V>(this.norm);
        }
    }
}

