/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

public class Log1PlusNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    public static final Log1PlusNormalization<NumberVector> STATIC = new Log1PlusNormalization(1.0);
    protected double boost;
    protected double scale;

    public Log1PlusNormalization(double boost) {
        this.boost = boost;
        this.scale = 1.0 / FastMath.log1p(boost);
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] data = new double[featureVector.getDimensionality()];
        for (int d = 0; d < data.length; ++d) {
            double v = featureVector.doubleValue(d);
            data[d] = FastMath.log1p((v > 0.0 ? v : -v) * this.boost) * this.scale;
        }
        return this.factory.newNumberVector(data);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID BOOST_ID = new OptionID("log1pscale.boost", "Boosting factor. Larger values will yield a steeper curve.");
        protected double boost;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter boostP = (DoubleParameter)new DoubleParameter(BOOST_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(boostP)) {
                this.boost = boostP.doubleValue();
            }
        }

        @Override
        protected Log1PlusNormalization<V> makeInstance() {
            return new Log1PlusNormalization(this.boost);
        }
    }
}

