/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class FirstNStreamFilter
extends AbstractStreamFilter {
    protected int n;

    public FirstNStreamFilter(int n) {
        this.n = n;
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.n == 0) {
                        return BundleStreamSource.Event.END_OF_STREAM;
                    }
                    --this.n;
                    return ev;
                }
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SIZE_ID = new OptionID("first.n", "Number of objects to keep.");
        protected int n;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter nP = (IntParameter)new IntParameter(SIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(nP)) {
                this.n = (Integer)nP.getValue();
            }
        }

        @Override
        protected FirstNStreamFilter makeInstance() {
            return new FirstNStreamFilter(this.n);
        }
    }
}

