/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.RandomSamplingStreamFilter"})
public class RandomSamplingStreamFilter
extends AbstractStreamFilter {
    protected double prob;
    protected Random random;

    public RandomSamplingStreamFilter(double prob, RandomFactory rnd) {
        this.prob = prob;
        this.random = rnd.getSingleThreadedRandom();
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (!(this.random.nextDouble() < this.prob)) continue block5;
                    return ev;
                }
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PROB_ID = new OptionID("sampling.p", "Sampling probability. Each object has a chance of being sampled with this probability.");
        public static final OptionID SEED_ID = new OptionID("sampling.seed", "Random generator seed for sampling.");
        protected double prob;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            super.makeOptions(config);
            DoubleParameter probP = (DoubleParameter)((DoubleParameter)new DoubleParameter(PROB_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(probP)) {
                this.prob = (Double)probP.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RandomSamplingStreamFilter makeInstance() {
            return new RandomSamplingStreamFilter(this.prob, this.rnd);
        }
    }
}

