/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ShuffleObjectsFilter"})
public class ShuffleObjectsFilter
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(ShuffleObjectsFilter.class);
    final RandomFactory rnd;

    public ShuffleObjectsFilter(RandomFactory rnd) {
        this.rnd = rnd;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int j;
        int i;
        if (LOG.isDebugging()) {
            LOG.debug("Shuffling the data set");
        }
        Random random = this.rnd.getSingleThreadedRandom();
        int size = objects.dataLength();
        int[] offsets = new int[size];
        for (i = 0; i < size; ++i) {
            offsets[i] = i;
        }
        for (i = size; i > 1; --i) {
            j = random.nextInt(i);
            int temp = offsets[j];
            offsets[j] = offsets[i - 1];
            offsets[i - 1] = temp;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (j = 0; j < objects.metaLength(); ++j) {
            List<?> in = objects.getColumn(j);
            ArrayList data = new ArrayList(size);
            for (int i2 = 0; i2 < size; ++i2) {
                data.add(in.get(offsets[i2]));
            }
            bundle.appendColumn(objects.meta(j), data);
        }
        return bundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SEED_ID = new OptionID("shuffle.seed", "Seed for randomly shuffling the rows for the database. If the parameter is not set, a random seed will be used.");
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            RandomParameter rndP = new RandomParameter(SEED_ID);
            if (config.grab(rndP)) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected ShuffleObjectsFilter makeInstance() {
            return new ShuffleObjectsFilter(this.rnd);
        }
    }
}

