/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.SortByLabelFilter"})
public class SortByLabelFilter
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(SortByLabelFilter.class);

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (LOG.isDebugging()) {
            LOG.debug("Sorting the data set");
        }
        int size = objects.dataLength();
        int[] offsets = new int[size];
        for (int i = 0; i < size; ++i) {
            offsets[i] = i;
        }
        int lblcol = FilterUtil.findLabelColumn(objects);
        if (lblcol == -1) {
            throw new AbortException("No label column found - cannot sort by label.");
        }
        IntegerArrayQuickSort.sort(offsets, (o1, o2) -> objects.data(o1, lblcol).toString().compareToIgnoreCase(objects.data(o2, lblcol).toString()));
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int j = 0; j < objects.metaLength(); ++j) {
            List<?> in = objects.getColumn(j);
            ArrayList data = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                data.add(in.get(offsets[i]));
            }
            bundle.appendColumn(objects.meta(j), data);
        }
        return bundle;
    }
}

