/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.typeconversions.ClassLabelFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractSupervisedProjectionVectorFilter<V extends NumberVector>
implements ObjectFilter {
    protected int tdim;

    public AbstractSupervisedProjectionVectorFilter(int projdimension) {
        this.tdim = projdimension;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int dataLength = objects.dataLength();
        if (dataLength == 0) {
            return objects;
        }
        List<?> classcolumn = null;
        for (int r = 0; r < objects.metaLength(); ++r) {
            List<?> castcolumn;
            SimpleTypeInformation<?> type = objects.meta(r);
            List<?> column = objects.getColumn(r);
            if (!TypeUtil.CLASSLABEL.isAssignableFromType(type)) continue;
            classcolumn = castcolumn = column;
            break;
        }
        if (classcolumn == null) {
            this.getLogger().warning("No class label column found (try " + ClassLabelFilter.class.getSimpleName() + ") -- cannot run " + this.getClass().getSimpleName());
            return objects;
        }
        boolean somesuccess = false;
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation<?> type = objects.meta(r);
            List<?> column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            List<?> vectorcolumn = column;
            VectorFieldTypeInformation vtype = (VectorFieldTypeInformation)type;
            NumberVector.Factory factory = (NumberVector.Factory)vtype.getFactory();
            int dim = vtype.getDimensionality();
            if (this.tdim > dim) {
                if (this.getLogger().isVerbose()) {
                    this.getLogger().verbose("Setting projection dimension to original dimension: projection dimension: " + this.tdim + " larger than original dimension: " + dim);
                }
                this.tdim = dim;
            }
            try {
                double[][] proj = this.computeProjectionMatrix(vectorcolumn, classcolumn, dim);
                for (int i = 0; i < dataLength; ++i) {
                    double[] pv = VMath.times(proj, ((NumberVector)vectorcolumn.get(i)).toArray());
                    vectorcolumn.set(i, factory.newNumberVector(pv));
                }
                bundle.appendColumn(this.convertedType(type, factory), column);
                somesuccess = true;
                continue;
            }
            catch (Exception e) {
                this.getLogger().error("Projection failed -- continuing with unprojected data!", e);
                bundle.appendColumn(type, column);
            }
        }
        if (!somesuccess) {
            this.getLogger().warning("No vector field of fixed dimensionality found.");
            return objects;
        }
        return bundle;
    }

    protected SimpleTypeInformation<?> convertedType(SimpleTypeInformation<?> in, NumberVector.Factory<V> factory) {
        return new VectorFieldTypeInformation(factory, this.tdim);
    }

    protected abstract Logging getLogger();

    protected abstract double[][] computeProjectionMatrix(List<V> var1, List<? extends ClassLabel> var2, int var3);

    protected <O> Map<O, IntList> partition(List<? extends O> classcolumn) {
        HashMap<O, IntList> classes = new HashMap<O, IntList>();
        Iterator<O> iter = classcolumn.iterator();
        int i = 0;
        while (iter.hasNext()) {
            O lbl = iter.next();
            IntList ids = (IntList)classes.get(lbl);
            if (ids == null) {
                ids = new IntArrayList();
                classes.put(lbl, ids);
            }
            ids.add(i);
            ++i;
        }
        return classes;
    }

    public static abstract class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID P_ID = new OptionID("projection.dim", "Projection dimensionality");
        protected int tdim;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter dimP = (IntParameter)new IntParameter(P_ID, 2).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(dimP)) {
                this.tdim = (Integer)dimP.getValue();
            }
        }
    }
}

