/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.transform.ClassicMultidimensionalScalingTransform;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.List;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"fastmds"})
@Priority(value=99)
public class FastMultidimensionalScalingTransform<I, O extends NumberVector>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(FastMultidimensionalScalingTransform.class);
    PrimitiveDistanceFunction<? super I> dist;
    int tdim;
    RandomFactory random;
    NumberVector.Factory<O> factory;

    public FastMultidimensionalScalingTransform(int tdim, PrimitiveDistanceFunction<? super I> dist, NumberVector.Factory<O> factory, RandomFactory random) {
        this.tdim = tdim;
        this.dist = dist;
        this.random = random;
        this.factory = factory;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int size = objects.dataLength();
        if (size == 0) {
            return objects;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation<?> type = objects.meta(r);
            List<?> column = objects.getColumn(r);
            if (!((SimpleTypeInformation)this.dist.getInputTypeRestriction()).isAssignableFromType(type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            List<?> castColumn = column;
            NumberVector.Factory<DoubleVector> factory = null;
            if (type instanceof VectorFieldTypeInformation) {
                VectorFieldTypeInformation ctype;
                VectorFieldTypeInformation vtype = ctype = (VectorFieldTypeInformation)type;
                factory = FilterUtil.guessFactory(vtype);
            } else {
                factory = DoubleVector.FACTORY;
            }
            bundle.appendColumn(new VectorFieldTypeInformation<DoubleVector>(factory, this.tdim), castColumn);
            double[][] imat = ClassicMultidimensionalScalingTransform.computeSquaredDistanceMatrix(castColumn, this.dist);
            ClassicMultidimensionalScalingTransform.doubleCenterSymmetric(imat);
            double[][] evs = new double[this.tdim][size];
            double[] lambda = new double[this.tdim];
            this.findEigenVectors(imat, evs, lambda);
            if (!this.dist.isSquared()) {
                for (int i = 0; i < this.tdim; ++i) {
                    lambda[i] = FastMath.sqrt(Math.abs(lambda[i]));
                }
            }
            double[] buf = new double[this.tdim];
            for (int i = 0; i < size; ++i) {
                for (int d = 0; d < this.tdim; ++d) {
                    buf[d] = lambda[d] * evs[d][i];
                }
                column.set(i, factory.newNumberVector(buf));
            }
        }
        return bundle;
    }

    protected void findEigenVectors(double[][] imat, double[][] evs, double[] lambda) {
        int size = imat.length;
        Random rnd = this.random.getSingleThreadedRandom();
        double[] tmp = new double[size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Learning projections", this.tdim, LOG) : null;
        int d = 0;
        while (d < this.tdim) {
            double delta;
            double[] cur = evs[d];
            this.randomInitialization(cur, rnd);
            double l = this.multiply(imat, cur, tmp);
            for (int iter = 0; iter < 100 && !((delta = this.updateEigenvector(tmp, cur, l)) < 1.0E-10); ++iter) {
                l = this.multiply(imat, cur, tmp);
            }
            lambda[d++] = l = this.estimateEigenvalue(imat, cur);
            LOG.incrementProcessed(prog);
            if (d == this.tdim) break;
            this.updateMatrix(imat, cur, l);
        }
        LOG.ensureCompleted(prog);
    }

    protected void randomInitialization(double[] out, Random rnd) {
        double l2 = 0.0;
        while (!(l2 > 0.0)) {
            for (int d = 0; d < out.length; ++d) {
                double val;
                out[d] = val = rnd.nextDouble();
                l2 += val * val;
            }
        }
        double s = 1.0 / FastMath.sqrt(l2);
        int d = 0;
        while (d < out.length) {
            int n = d++;
            out[n] = out[n] * s;
        }
    }

    protected double multiply(double[][] mat, double[] in, double[] out) {
        double l = 0.0;
        for (int d1 = 0; d1 < in.length; ++d1) {
            double[] row = mat[d1];
            double t = 0.0;
            for (int d2 = 0; d2 < in.length; ++d2) {
                t += row[d2] * in[d2];
            }
            out[d1] = t;
            l += t * t;
        }
        return l > 0.0 ? FastMath.sqrt(l) : 0.0;
    }

    protected double updateEigenvector(double[] in, double[] out, double l) {
        double s = 1.0 / (l > 0.0 ? l : (l < 0.0 ? -l : 1.0));
        s = in[0] > 0.0 ? s : -s;
        double diff = 0.0;
        for (int d = 0; d < in.length; ++d) {
            int n = d;
            in[n] = in[n] * s;
            double delta = in[d] - out[d];
            diff += delta * delta;
            out[d] = in[d];
        }
        return diff;
    }

    protected double estimateEigenvalue(double[][] mat, double[] in) {
        double de = 0.0;
        double di = 0.0;
        for (int d1 = 0; d1 < in.length; ++d1) {
            double[] row = mat[d1];
            double t = 0.0;
            for (int d2 = 0; d2 < in.length; ++d2) {
                t += row[d2] * in[d2];
            }
            double s = in[d1];
            de += t * s;
            di += s * s;
        }
        return de / di;
    }

    protected void updateMatrix(double[][] mat, double[] evec, double eval) {
        int size = mat.length;
        for (int i = 0; i < size; ++i) {
            double[] mati = mat[i];
            double eveci = evec[i];
            for (int j = 0; j < size; ++j) {
                int n = j;
                mati[n] = mati[n] - eval * eveci * evec[j];
            }
        }
    }

    public static class Parameterizer<I, O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("mds.seed", "Random seed for fast MDS.");
        int tdim;
        PrimitiveDistanceFunction<? super I> dist = null;
        RandomFactory random = RandomFactory.DEFAULT;
        NumberVector.Factory<O> factory;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter factoryP;
            RandomParameter randP;
            ObjectParameter distP;
            super.makeOptions(config);
            IntParameter dimP = new IntParameter(ClassicMultidimensionalScalingTransform.Parameterizer.DIM_ID);
            if (config.grab(dimP)) {
                this.tdim = dimP.intValue();
            }
            if (config.grab(distP = new ObjectParameter(ClassicMultidimensionalScalingTransform.Parameterizer.DISTANCE_ID, (Class<?>)PrimitiveDistanceFunction.class, SquaredEuclideanDistanceFunction.class))) {
                this.dist = (PrimitiveDistanceFunction)distP.instantiateClass(config);
            }
            if (config.grab(randP = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randP.getValue();
            }
            if (config.grab(factoryP = new ObjectParameter(ClassicMultidimensionalScalingTransform.Parameterizer.VECTOR_TYPE_ID, (Class<?>)NumberVector.Factory.class, DoubleVector.Factory.class))) {
                this.factory = (NumberVector.Factory)factoryP.instantiateClass(config);
            }
        }

        @Override
        protected FastMultidimensionalScalingTransform<I, O> makeInstance() {
            return new FastMultidimensionalScalingTransform<I, O>(this.tdim, this.dist, this.factory, this.random);
        }
    }
}

