/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Alias(value={"whiten", "whitening", "pca"})
@Priority(value=200)
public class GlobalPrincipalComponentAnalysisTransform<O extends NumberVector>
extends AbstractVectorConversionFilter<O, O> {
    private static final Logging LOG = Logging.getLogger(GlobalPrincipalComponentAnalysisTransform.class);
    EigenPairFilter filter = null;
    CovarianceMatrix covmat = null;
    double[][] proj = null;
    double[] buf = null;
    double[] mean = null;
    Mode mode;

    public GlobalPrincipalComponentAnalysisTransform(EigenPairFilter filter) {
        this(filter, Mode.FULL);
    }

    public GlobalPrincipalComponentAnalysisTransform(EigenPairFilter filter, Mode mode) {
        this.filter = filter;
        this.mode = mode;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<O> in) {
        if (!(in instanceof VectorFieldTypeInformation)) {
            throw new AbortException("PCA can only applied to fixed dimensionality vectors");
        }
        int dim = ((VectorFieldTypeInformation)in).getDimensionality();
        this.covmat = new CovarianceMatrix(dim);
        this.proj = null;
        this.mean = null;
        return true;
    }

    @Override
    protected void prepareProcessInstance(O obj) {
        this.covmat.put((NumberVector)obj);
    }

    @Override
    protected void prepareComplete() {
        int pdim;
        this.mean = this.covmat.getMeanVector();
        PCAResult pcares = new PCARunner(null).processCovarMatrix(this.covmat.destroyToPopulationMatrix());
        this.covmat = null;
        int dim = this.mean.length;
        int n = pdim = this.filter != null ? this.filter.filter(pcares.getEigenvalues()) : dim;
        if (this.filter != null && LOG.isVerbose()) {
            LOG.verbose("Reducing dimensionality from " + dim + " to " + pdim + " via PCA.");
        }
        this.proj = new double[pdim][dim];
        for (int d = 0; d < pdim; ++d) {
            EigenPair ep = pcares.getEigenPairs()[d];
            VMath.plusTimesEquals(this.proj[d], ep.getEigenvector(), this.mode == Mode.FULL ? 1.0 / FastMath.sqrt(ep.getEigenvalue()) : 1.0);
        }
        this.buf = new double[dim];
    }

    @Override
    protected O filterSingleObject(O obj) {
        for (int i = 0; i < this.mean.length; ++i) {
            this.buf[i] = obj.doubleValue(i) - this.mean[i];
        }
        return (O)this.factory.newNumberVector(VMath.times(this.proj, this.buf));
    }

    @Override
    protected SimpleTypeInformation<? super O> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<O> in) {
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation(this.factory, this.proj.length);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID FILTER_ID = new OptionID("globalpca.filter", "Filter to use for dimensionality reduction.");
        public static final OptionID MODE_ID = new OptionID("globalpca.mode", "Operation mode: full, or rotate only.");
        EigenPairFilter filter = null;
        Mode mode;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<Mode> modeP;
            super.makeOptions(config);
            ObjectParameter filterP = new ObjectParameter(FILTER_ID, EigenPairFilter.class, true);
            if (config.grab(filterP)) {
                this.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
            if (config.grab(modeP = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.FULL))) {
                this.mode = (Mode)((Object)modeP.getValue());
            }
        }

        @Override
        protected GlobalPrincipalComponentAnalysisTransform<O> makeInstance() {
            return new GlobalPrincipalComponentAnalysisTransform(this.filter, this.mode);
        }
    }

    public static enum Mode {
        FULL,
        CENTER_ROTATE;

    }
}

