/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Description(value="Add uniform Jitter to a dataset, while preserving the total vector sum.")
@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.HistogramJitterFilter"})
public class HistogramJitterFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    double jitter;
    ExponentialDistribution rnd;

    public HistogramJitterFilter(double jitter, RandomFactory rnd) {
        this.jitter = jitter;
        this.rnd = new ExponentialDistribution(1.0, rnd.getSingleThreadedRandom());
    }

    @Override
    protected V filterSingleObject(V obj) {
        int dim = obj.getDimensionality();
        double osum = 0.0;
        for (int i = 0; i < dim; ++i) {
            osum += obj.doubleValue(i);
        }
        double maxjitter = 2.0 * this.jitter / (double)dim * osum;
        double[] raw = new double[dim];
        double jsum = 0.0;
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = this.rnd.nextRandom() * maxjitter;
            jsum += raw[i];
        }
        double mix = jsum / osum;
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = raw[i] + (1.0 - mix) * obj.doubleValue(i);
        }
        return this.factory.newNumberVector(raw);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected SimpleTypeInformation<V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID JITTER_ID = new OptionID("jitter.amount", "Jitter amount relative to data.");
        public static final OptionID SEED_ID = new OptionID("jitter.seed", "Jitter random seed.");
        double jitter = 0.1;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            super.makeOptions(config);
            DoubleParameter jitterP = (DoubleParameter)new DoubleParameter(JITTER_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(jitterP)) {
                this.jitter = (Double)jitterP.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected HistogramJitterFilter<DoubleVector> makeInstance() {
            return new HistogramJitterFilter<DoubleVector>(this.jitter, this.rnd);
        }
    }
}

