/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LatLngToECEFFilter<V extends NumberVector>
extends AbstractStreamConversionFilter<V, V> {
    private NumberVector.Factory<V> factory;
    private EarthModel model;

    public LatLngToECEFFilter(EarthModel model) {
        this.model = model;
    }

    @Override
    protected V filterSingleObject(V obj) {
        return this.factory.newNumberVector(this.model.latLngDegToECEF(obj.doubleValue(0), obj.doubleValue(1)));
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.factory = FilterUtil.guessFactory(in);
        return new VectorFieldTypeInformation<V>(this.factory, 3, 3, in.getSerializer());
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        private EarthModel model;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (config.grab(modelP)) {
                this.model = (EarthModel)modelP.instantiateClass(config);
            }
        }

        @Override
        protected LatLngToECEFFilter<V> makeInstance() {
            return new LatLngToECEFFilter(this.model);
        }
    }
}

