/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.projection.FeatureSelection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

public class NumberVectorFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    private long[] selectedAttributes;

    public NumberVectorFeatureSelectionFilter(long[] selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    @Override
    protected V filterSingleObject(V obj) {
        return VectorUtil.project(obj, this.getSelectedAttributes(), this.factory);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation(this.factory, this.getDimensionality());
    }

    public void setSelectedAttributes(long[] selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public long[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public int getDimensionality() {
        return BitsUtil.cardinality(this.selectedAttributes);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = FeatureSelection.Parameterizer.SELECTED_ATTRIBUTES_ID;
        protected long[] selectedAttributes;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntListParameter selectedAttributesP = (IntListParameter)new IntListParameter(SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (config.grab(selectedAttributesP)) {
                this.selectedAttributes = selectedAttributesP.getValueAsBitSet();
            }
        }

        @Override
        protected NumberVectorFeatureSelectionFilter<DoubleVector> makeInstance() {
            return new NumberVectorFeatureSelectionFilter<DoubleVector>(this.selectedAttributes);
        }
    }
}

