/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class NumberVectorRandomFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    protected long[] selectedAttributes = null;
    protected int k;
    protected RandomFactory rnd;

    public NumberVectorRandomFeatureSelectionFilter(int dim, RandomFactory rnd) {
        this.k = dim;
        this.rnd = rnd;
    }

    @Override
    protected V filterSingleObject(V obj) {
        return VectorUtil.project(obj, this.selectedAttributes, this.factory);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeRandomAttributes(in);
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation(this.factory, this.k);
    }

    void initializeRandomAttributes(SimpleTypeInformation<V> in) {
        int d = ((VectorFieldTypeInformation)in).getDimensionality();
        this.selectedAttributes = BitsUtil.random(this.k, d, this.rnd.getSingleThreadedRandom());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NUMBER_SELECTED_ATTRIBUTES_ID = new OptionID("randomprojection.numberselected", "number of selected attributes");
        public static final OptionID SEED_ID = new OptionID("randomprojection.seed", "Seed for random selection of projection attributes.");
        protected int k = 0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(NUMBER_SELECTED_ATTRIBUTES_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected NumberVectorRandomFeatureSelectionFilter<DoubleVector> makeInstance() {
            return new NumberVectorRandomFeatureSelectionFilter<DoubleVector>(this.k, this.rnd);
        }
    }
}

