/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ClassLabelFilter"})
public class ClassLabelFilter
implements ObjectFilter {
    private final int classLabelIndex;
    private final ClassLabel.Factory<?> classLabelFactory;

    public ClassLabelFilter(int classLabelIndex, ClassLabel.Factory<?> classLabelFactory) {
        this.classLabelIndex = classLabelIndex;
        this.classLabelFactory = classLabelFactory;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        boolean done = false;
        boolean keeplabelcol = false;
        for (int i = 0; i < objects.metaLength(); ++i) {
            SimpleTypeInformation<?> meta = objects.meta(i);
            if (done || !LabelList.class.equals(meta.getRestrictionClass())) {
                bundle.appendColumn(meta, objects.getColumn(i));
                continue;
            }
            done = true;
            ArrayList clscol = new ArrayList(objects.dataLength());
            ArrayList<LabelList> lblcol = new ArrayList<LabelList>(objects.dataLength());
            ArrayList<String> lbuf = new ArrayList<String>();
            for (Object obj : objects.getColumn(i)) {
                if (obj != null) {
                    LabelList ll = (LabelList)obj;
                    int off = this.classLabelIndex >= 0 ? this.classLabelIndex : ll.size() - this.classLabelIndex;
                    try {
                        Object lbl = this.classLabelFactory.makeFromString(ll.get(off));
                        clscol.add(lbl);
                    }
                    catch (Exception e) {
                        throw new AbortException("Cannot initialize class labels: " + e.getMessage(), e);
                    }
                    lbuf.clear();
                    for (int j = 0; j < ll.size(); ++j) {
                        if (j == off) continue;
                        lbuf.add(ll.get(j));
                    }
                    lblcol.add(LabelList.make(lbuf));
                    if (lbuf.isEmpty()) continue;
                    keeplabelcol = true;
                    continue;
                }
                clscol.add(null);
                lblcol.add(null);
            }
            bundle.appendColumn(this.classLabelFactory.getTypeInformation(), clscol);
            if (!keeplabelcol) continue;
            bundle.appendColumn(meta, lblcol);
        }
        return bundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID CLASS_LABEL_INDEX_ID = new OptionID("dbc.classLabelIndex", "The index of the label to be used as class label. The first label is 0, negative indexes are relative to the end.");
        public static final OptionID CLASS_LABEL_CLASS_ID = new OptionID("dbc.classLabelClass", "Class label class to use.");
        protected int classLabelIndex;
        private ClassLabel.Factory<?> classLabelFactory;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter classLabelIndexParam = new IntParameter(CLASS_LABEL_INDEX_ID);
            ObjectParameter classlabelClassParam = new ObjectParameter(CLASS_LABEL_CLASS_ID, (Class<?>)ClassLabel.Factory.class, SimpleClassLabel.Factory.class);
            config.grab(classLabelIndexParam);
            config.grab(classlabelClassParam);
            if (classLabelIndexParam.isDefined() && classlabelClassParam.isDefined()) {
                this.classLabelIndex = classLabelIndexParam.intValue();
                this.classLabelFactory = (ClassLabel.Factory)classlabelClassParam.instantiateClass(config);
            }
        }

        @Override
        protected ClassLabelFilter makeInstance() {
            return new ClassLabelFilter(this.classLabelIndex, this.classLabelFactory);
        }
    }
}

