/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ClassLabelFromPatternFilter"})
public class ClassLabelFromPatternFilter
extends AbstractStreamFilter {
    BundleMeta meta = null;
    IntArrayList labelcols = new IntArrayList();
    SimpleClassLabel positive;
    SimpleClassLabel negative;
    Pattern pattern;

    public ClassLabelFromPatternFilter(Pattern pattern, String positive, String negative) {
        this.pattern = pattern;
        this.positive = new SimpleClassLabel(positive);
        this.negative = new SimpleClassLabel(negative);
    }

    public ClassLabelFromPatternFilter(Pattern pattern, SimpleClassLabel positive, SimpleClassLabel negative) {
        this.pattern = pattern;
        this.positive = positive;
        this.negative = negative;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            BundleMeta origmeta = this.source.getMeta();
            this.meta = new BundleMeta(origmeta.size() + 1);
            this.meta.add(TypeUtil.SIMPLE_CLASSLABEL);
            this.labelcols.clear();
            for (int i = 0; i < origmeta.size(); ++i) {
                SimpleTypeInformation orig = (SimpleTypeInformation)origmeta.get(i);
                if (TypeUtil.GUESSED_LABEL.isAssignableFromType(orig)) {
                    this.labelcols.add(i);
                }
                this.meta.add(orig);
            }
        }
        return this.meta;
    }

    @Override
    public Object data(int rnum) {
        if (rnum > 0) {
            return this.source.data(rnum - 1);
        }
        if (this.meta == null) {
            this.getMeta();
        }
        for (int i = 0; i < this.labelcols.size(); ++i) {
            Object o = this.source.data(this.labelcols.getInt(i));
            if (o == null) continue;
            if (o instanceof LabelList) {
                LabelList ll = (LabelList)o;
                for (int j = 0; j < ll.size(); ++j) {
                    if (!this.pattern.matcher(ll.get(j)).find()) continue;
                    return this.positive;
                }
                continue;
            }
            if (!this.pattern.matcher(o.toString()).find()) continue;
            return this.positive;
        }
        return this.negative;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        BundleStreamSource.Event ev = this.source.nextEvent();
        if (BundleStreamSource.Event.META_CHANGED.equals((Object)ev)) {
            this.meta = null;
        }
        return ev;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PATTERN_ID = new OptionID("class.pattern", "Regular expression to identify positive objects.");
        public static final OptionID POSITIVE_ID = new OptionID("class.positive", "Class label to use for positive instances.");
        public static final OptionID NEGATIVE_ID = new OptionID("class.negative", "Class label to use for negative instances.");
        Pattern pattern;
        String positive;
        String negative;

        @Override
        protected void makeOptions(Parameterization config) {
            StringParameter negativeP;
            StringParameter positiveP;
            super.makeOptions(config);
            PatternParameter patternP = new PatternParameter(PATTERN_ID);
            if (config.grab(patternP)) {
                this.pattern = (Pattern)patternP.getValue();
            }
            if (config.grab(positiveP = new StringParameter(POSITIVE_ID, "positive"))) {
                this.positive = (String)positiveP.getValue();
            }
            if (config.grab(negativeP = new StringParameter(NEGATIVE_ID, "negative"))) {
                this.negative = (String)negativeP.getValue();
            }
        }

        @Override
        protected ClassLabelFromPatternFilter makeInstance() {
            return new ClassLabelFromPatternFilter(this.pattern, this.positive, this.negative);
        }
    }
}

