/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ExternalIDFilter"})
public class ExternalIDFilter
implements ObjectFilter {
    private final int externalIdIndex;

    public ExternalIDFilter(int externalIdIndex) {
        this.externalIdIndex = externalIdIndex;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        boolean done = false;
        boolean keeplabelcol = false;
        for (int i = 0; i < objects.metaLength(); ++i) {
            SimpleTypeInformation<?> meta = objects.meta(i);
            if (done || !LabelList.class.equals(meta.getRestrictionClass())) {
                bundle.appendColumn(meta, objects.getColumn(i));
                continue;
            }
            done = true;
            ArrayList<ExternalID> eidcol = new ArrayList<ExternalID>(objects.dataLength());
            ArrayList<LabelList> lblcol = new ArrayList<LabelList>(objects.dataLength());
            ArrayList<String> lbuf = new ArrayList<String>();
            for (Object obj : objects.getColumn(i)) {
                if (obj != null) {
                    LabelList ll = (LabelList)obj;
                    int off = this.externalIdIndex >= 0 ? this.externalIdIndex : ll.size() - this.externalIdIndex;
                    eidcol.add(new ExternalID(ll.get(off)));
                    lbuf.clear();
                    for (int j = 0; j < ll.size(); ++j) {
                        if (j == off) continue;
                        lbuf.add(ll.get(j));
                    }
                    lblcol.add(LabelList.make(lbuf));
                    if (ll.size() <= 0) continue;
                    keeplabelcol = true;
                    continue;
                }
                eidcol.add(null);
                lblcol.add(null);
            }
            bundle.appendColumn(TypeUtil.EXTERNALID, eidcol);
            if (!keeplabelcol) continue;
            bundle.appendColumn(meta, lblcol);
        }
        return bundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EXTERNALID_INDEX_ID = new OptionID("dbc.externalIdIndex", "The index of the label to be used as external Id. The first label is 0; negative indexes are relative to the end.");
        int externalIdIndex = -1;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter externalIdIndexParam = new IntParameter(EXTERNALID_INDEX_ID);
            if (config.grab(externalIdIndexParam)) {
                this.externalIdIndex = externalIdIndexParam.intValue();
            }
        }

        @Override
        protected ExternalIDFilter makeInstance() {
            return new ExternalIDFilter(this.externalIdIndex);
        }
    }
}

