/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.type.MultivariateSeriesTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class MultivariateTimeSeriesFilter<V extends FeatureVector<?>>
extends AbstractStreamConversionFilter<V, V> {
    private static final Logging LOG = Logging.getLogger(MultivariateTimeSeriesFilter.class);
    int variates;

    public MultivariateTimeSeriesFilter(int variates) {
        this.variates = variates;
    }

    @Override
    protected V filterSingleObject(V obj) {
        if (obj.getDimensionality() % this.variates != 0) {
            throw new AbortException("Vector length " + obj.getDimensionality() + " not divisible by the number of variates " + this.variates);
        }
        return obj;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.FEATURE_VECTORS;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        VectorTypeInformation vin = (VectorTypeInformation)in;
        return new MultivariateSeriesTypeInformation(vin.getFactory(), in.getSerializer(), vin.mindim(), vin.maxdim(), this.variates);
    }

    public static class Parameterizer<V extends FeatureVector<?>>
    extends AbstractParameterizer {
        public static final OptionID VARIATES_ID = new OptionID("series.variates", "Number of variates this time series has.");
        int variates;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter variatesP = (IntParameter)new IntParameter(VARIATES_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(variatesP)) {
                this.variates = variatesP.intValue();
                if (this.variates == 1) {
                    LOG.warning("For univariate series, you should not need to use this filter.");
                }
            }
        }

        @Override
        protected MultivariateTimeSeriesFilter<V> makeInstance() {
            return new MultivariateTimeSeriesFilter(this.variates);
        }
    }
}

