/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UnweightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class UncertainSplitFilter
extends AbstractConversionFilter<NumberVector, UnweightedDiscreteUncertainObject> {
    private static final Logging LOG = Logging.getLogger(UncertainSplitFilter.class);
    private int dims;

    public UncertainSplitFilter(int dims) {
        this.dims = dims;
    }

    @Override
    protected UnweightedDiscreteUncertainObject filterSingleObject(NumberVector vec) {
        int dim = vec.getDimensionality();
        if (dim % this.dims != 0) {
            throw new AbortException("Vector length " + dim + " not divisible by the number of dimensions " + this.dims);
        }
        int num = dim / this.dims;
        DoubleVector[] samples = new DoubleVector[num];
        double[] buf = new double[this.dims];
        int j = 0;
        int k = 0;
        for (int i = 0; i < dim; ++i) {
            buf[j++] = vec.doubleValue(i);
            if (j != this.dims) continue;
            samples[k++] = DoubleVector.copy(buf);
            j = 0;
        }
        return new UnweightedDiscreteUncertainObject(samples);
    }

    @Override
    protected SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<UnweightedDiscreteUncertainObject> convertedType(SimpleTypeInformation<NumberVector> in) {
        int dim = ((VectorFieldTypeInformation)in).getDimensionality();
        if (dim % this.dims != 0) {
            throw new AbortException("Vector length " + dim + " not divisible by the number of dimensions " + this.dims);
        }
        return new VectorFieldTypeInformation<UnweightedDiscreteUncertainObject>(UnweightedDiscreteUncertainObject.FACTORY, dim);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("uncertain.dimensionality", "Dimensionality of the data set (used for splitting).");
        protected int dims;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter dimsP = (IntParameter)new IntParameter(DIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(dimsP)) {
                this.dims = dimsP.intValue();
            }
        }

        @Override
        protected UncertainSplitFilter makeInstance() {
            return new UncertainSplitFilter(this.dims);
        }
    }
}

