/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UncertainifyFilter<UO extends UncertainObject>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(UncertainifyFilter.class);
    protected Uncertainifier<UO> generator;
    protected boolean keep;
    protected Random rand;

    public UncertainifyFilter(Uncertainifier<UO> generator, boolean keep, RandomFactory randf) {
        this.generator = generator;
        this.keep = keep;
        this.rand = randf.getSingleThreadedRandom();
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation<?> type = objects.meta(r);
            List<?> column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            VectorFieldTypeInformation castType = (VectorFieldTypeInformation)type;
            int dim = castType.getDimensionality();
            if (this.keep) {
                bundle.appendColumn(type, column);
            }
            ArrayList<UO> uos = new ArrayList<UO>(column.size());
            FiniteProgress nprog = LOG.isVerbose() ? new FiniteProgress("Derive uncertain objects", objects.dataLength(), LOG) : null;
            for (int i = 0; i < objects.dataLength(); ++i) {
                NumberVector obj = (NumberVector)column.get(i);
                UO normalizedObj = this.generator.newFeatureVector(this.rand, obj, ArrayLikeUtil.NUMBERVECTORADAPTER);
                uos.add(normalizedObj);
                LOG.incrementProcessed(nprog);
            }
            LOG.ensureCompleted(nprog);
            bundle.appendColumn(new VectorFieldTypeInformation<UO>(this.generator.getFactory(), dim), uos);
        }
        return bundle;
    }

    public static class Parameterizer<UO extends UncertainObject>
    extends AbstractParameterizer {
        public static final OptionID UNCERTAINITY_MODEL_ID = new OptionID("uofilter.generator", "Generator to derive uncertain objects from certain vectors.");
        public static final OptionID KEEP_ID = new OptionID("uofilter.keep", "Keep the original data as well.");
        public static final OptionID SEED_ID = new OptionID("uofilter.seed", "Random seed for uncertainification.");
        protected Uncertainifier<UO> generator;
        protected boolean keep;
        protected RandomFactory rand;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            Flag keepF;
            super.makeOptions(config);
            ObjectParameter generatorP = new ObjectParameter(UNCERTAINITY_MODEL_ID, Uncertainifier.class);
            if (config.grab(generatorP)) {
                this.generator = (Uncertainifier)generatorP.instantiateClass(config);
            }
            if (config.grab(keepF = new Flag(KEEP_ID))) {
                this.keep = keepF.isTrue();
            }
            if (config.grab(randomP = new RandomParameter(SEED_ID))) {
                this.rand = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected UncertainifyFilter<UO> makeInstance() {
            return new UncertainifyFilter<UO>(this.generator, this.keep, this.rand);
        }
    }
}

