/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.WeightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class WeightedUncertainSplitFilter
extends AbstractConversionFilter<NumberVector, WeightedDiscreteUncertainObject> {
    private static final Logging LOG = Logging.getLogger(WeightedUncertainSplitFilter.class);
    protected int dims;
    protected int mod;
    protected int probcol;

    public WeightedUncertainSplitFilter(int dims, int probcol) {
        this.dims = dims;
        if (probcol < -dims || probcol >= dims) {
            throw new AbortException("Invalid column given for prob: " + probcol);
        }
        if (probcol < 0) {
            probcol += dims;
        }
        this.probcol = probcol;
        this.mod = dims + 1;
    }

    @Override
    protected WeightedDiscreteUncertainObject filterSingleObject(NumberVector vec) {
        int dim = vec.getDimensionality();
        if (dim % this.mod != 0) {
            throw new AbortException("Vector length " + dim + " not divisible by the number of dimensions + 1 (for probability): " + this.mod);
        }
        int num = dim / this.mod;
        DoubleVector[] samples = new DoubleVector[num];
        double[] weights = new double[this.dims];
        double[] buf = new double[this.dims];
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i = 0; i < this.mod; ++i) {
            if (l++ == this.probcol) {
                weights[k] = vec.doubleValue(i);
            } else {
                buf[j++] = vec.doubleValue(i);
            }
            if (l != this.mod) continue;
            samples[k] = DoubleVector.copy(buf);
            j = 0;
            l = 0;
            ++k;
        }
        return new WeightedDiscreteUncertainObject(samples, weights);
    }

    @Override
    protected SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<WeightedDiscreteUncertainObject> convertedType(SimpleTypeInformation<NumberVector> in) {
        int dim = ((VectorFieldTypeInformation)in).getDimensionality();
        if (dim % this.mod != 0) {
            throw new AbortException("Vector length " + dim + " not divisible by the number of dimensions + 1 (for probability): " + this.mod);
        }
        return new VectorFieldTypeInformation<WeightedDiscreteUncertainObject>(WeightedDiscreteUncertainObject.FACTORY, dim);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("uncertain.dimensionality", "Dimensionality of the data set (used for splitting).");
        public static final OptionID PROBCOL_ID = new OptionID("uncertain.probability.column", "Column in which the probability is stored, starting at 0. -1 is the last column.");
        protected int dims = 0;
        protected int probcol = Integer.MIN_VALUE;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter dimsP = (IntParameter)new IntParameter(DIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            IntParameter probP = new IntParameter(PROBCOL_ID);
            if (config.grab(dimsP)) {
                this.dims = dimsP.intValue();
                ((IntParameter)probP.addConstraint((ParameterConstraint)new LessConstraint(dimsP.intValue()))).addConstraint((ParameterConstraint)new GreaterEqualConstraint(-dimsP.intValue()));
            }
            if (config.grab(probP)) {
                this.probcol = probP.intValue();
            }
        }

        @Override
        protected WeightedUncertainSplitFilter makeInstance() {
            return new WeightedUncertainSplitFilter(this.dims, this.probcol);
        }
    }
}

