/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractStreamingParser
implements StreamingParser {
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AbstractStreamingParser(CSVReaderFormat format) {
        this.reader = format.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public final MultipleObjectsBundle parse(InputStream in) {
        this.initStream(in);
        return MultipleObjectsBundle.fromStream(this);
    }

    @Override
    public void initStream(InputStream in) {
        this.reader.reset(in);
    }

    @Override
    public boolean hasDBIDs() {
        return false;
    }

    @Override
    public boolean assignDBID(DBIDVar var) {
        var.unset();
        return false;
    }

    @Override
    public MultipleObjectsBundle asMultipleObjectsBundle() {
        return MultipleObjectsBundle.fromStream(this);
    }

    @Override
    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.getLogger().exception(e);
        }
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        protected CSVReaderFormat format;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.format = config.tryInstantiate(CSVReaderFormat.class);
        }

        @Override
        protected abstract AbstractStreamingParser makeInstance();
    }
}

