/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import it.unimi.dsi.fastutil.longs.LongArrayList;

@Title(value="Bit Vector Label Parser")
@Description(value="Parses the following format of lines:\nA single line provides a single BitVector. Bits are separated by whitespace. Any substring not containing whitespace is tried to be read as Bit. If this fails, it will be appended to a label. (Thus, any label must not be parseable as Bit.) Empty lines and lines beginning with \"#\" will be ignored.")
@Alias(value={"de.lmu.ifi.dbs.elki.parser.BitVectorLabelParser"})
public class BitVectorLabelParser
extends NumberVectorLabelParser<BitVector> {
    private static final Logging LOG = Logging.getLogger(BitVectorLabelParser.class);
    LongArrayList buf = new LongArrayList();

    public BitVectorLabelParser(CSVReaderFormat format) {
        super(format, null, BitVector.FACTORY);
    }

    @Override
    protected boolean parseLineInternal() {
        int curdim = 0;
        while (this.tokenizer.valid()) {
            try {
                int word = curdim >>> 6;
                int off = curdim & 0x3F;
                if (word >= this.buf.size()) {
                    this.buf.add(0L);
                }
                if (this.tokenizer.getIntBase10() > 0) {
                    this.buf.set(word, this.buf.getLong(word) | 1L << off);
                }
                ++curdim;
            }
            catch (NumberFormatException e) {
                this.labels.add(this.tokenizer.getSubstring());
            }
            this.tokenizer.advance();
        }
        if (curdim == 0) {
            return false;
        }
        this.curvec = new BitVector(this.buf.toLongArray(), curdim);
        this.curlbl = LabelList.make(this.labels);
        this.buf.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected BitVectorLabelParser makeInstance() {
            return new BitVectorLabelParser(this.format);
        }
    }
}

