/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.util.regex.Pattern;

public class CSVReaderFormat {
    public static final String DEFAULT_SEPARATOR = "\\s*[,;\\s]\\s*";
    public static final String QUOTE_CHARS = "\"'";
    public static final String NUMBER_PATTERN = "[+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?";
    public static final String COMMENT_PATTERN = "^\\s*(#|//|;).*$";
    public static final String ATTRIBUTE_CONCATENATION = " ";
    public static final CSVReaderFormat DEFAULT_FORMAT = new CSVReaderFormat(Pattern.compile("\\s*[,;\\s]\\s*"), "\"'", Pattern.compile("^\\s*(#|//|;).*$"));
    protected Pattern colSep = null;
    protected String quoteChars = "\"'";
    protected Pattern comment = null;

    public CSVReaderFormat(Pattern colSep, String quoteChars, Pattern comment) {
        this.colSep = colSep;
        this.quoteChars = quoteChars;
        this.comment = comment;
    }

    public TokenizedReader makeReader() {
        return new TokenizedReader(this.colSep, this.quoteChars, this.comment);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID COLUMN_SEPARATOR_ID = new OptionID("parser.colsep", "Column separator pattern. The default assumes whitespace separated data.");
        public static final OptionID QUOTE_ID = new OptionID("parser.quote", "Quotation characters. By default, both double and single ASCII quotes are accepted.");
        public static final OptionID COMMENT_ID = new OptionID("string.comment", "Ignore lines in the input file that satisfy this pattern.");
        protected Pattern colSep = null;
        protected String quoteChars = "\"'";
        protected Pattern comment = null;

        @Override
        protected void makeOptions(Parameterization config) {
            PatternParameter commentP;
            StringParameter quoteParam;
            super.makeOptions(config);
            PatternParameter colParam = new PatternParameter(COLUMN_SEPARATOR_ID, CSVReaderFormat.DEFAULT_SEPARATOR);
            if (config.grab(colParam)) {
                this.colSep = (Pattern)colParam.getValue();
            }
            if (config.grab(quoteParam = new StringParameter(QUOTE_ID, CSVReaderFormat.QUOTE_CHARS))) {
                this.quoteChars = (String)quoteParam.getValue();
            }
            if (config.grab(commentP = new PatternParameter(COMMENT_ID, CSVReaderFormat.COMMENT_PATTERN))) {
                this.comment = (Pattern)commentP.getValue();
            }
        }

        @Override
        protected CSVReaderFormat makeInstance() {
            return new CSVReaderFormat(this.colSep, this.quoteChars, this.comment);
        }
    }
}

