/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseFloatVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.SparseNumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.regex.Pattern;

@Title(value="libSVM Format Parser")
public class LibSVMFormatParser<V extends SparseNumberVector>
extends SparseNumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(LibSVMFormatParser.class);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+|:)");
    public static final Pattern COMMENT_PATTERN = Pattern.compile("#");

    public LibSVMFormatParser(SparseNumberVector.Factory<V> factory) {
        super(WHITESPACE_PATTERN, (String)null, COMMENT_PATTERN, (long[])null, factory);
    }

    @Override
    protected boolean parseLineInternal() {
        int thismax = 0;
        this.labels.add(this.tokenizer.getSubstring());
        this.tokenizer.advance();
        this.haslabels = true;
        while (this.tokenizer.valid()) {
            try {
                int index = this.tokenizer.getIntBase10();
                this.tokenizer.advance();
                double attribute = this.tokenizer.getDouble();
                this.tokenizer.advance();
                thismax = Math.max(thismax, index + 1);
                this.values.put(index, attribute);
            }
            catch (NumberFormatException e) {
                String comment = this.tokenizer.getSubstring();
                if (comment.charAt(0) == '#') break;
                throw new RuntimeException("Parsing error in line " + this.reader.getLineNumber() + ": expected data, got " + comment);
            }
        }
        this.curvec = this.sparsefactory.newNumberVector(this.values, thismax);
        this.curlbl = LabelList.make(this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Parameterizer<V> {
        @Override
        protected void getFactory(Parameterization config) {
            ObjectParameter factoryP = new ObjectParameter(VECTOR_TYPE_ID, (Class<?>)SparseNumberVector.Factory.class, SparseFloatVector.Factory.class);
            if (config.grab(factoryP)) {
                this.factory = (NumberVector.Factory)factoryP.instantiateClass(config);
            }
        }

        @Override
        protected void makeOptions(Parameterization config) {
            this.getFactory(config);
        }

        @Override
        protected LibSVMFormatParser<V> makeInstance() {
            return new LibSVMFormatParser((SparseNumberVector.Factory)this.factory);
        }
    }
}

