/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimplePolygonParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimplePolygonParser.class);
    public static final Pattern COORD = Pattern.compile("^([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?),\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?)(?:,\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?))?$");
    public static final String POLYGON_SEPARATOR = "--";
    BundleStreamSource.Event nextevent = null;
    protected BundleMeta meta = null;
    protected boolean haslabels = false;
    protected PolygonsObject curpoly = null;
    protected LabelList curlbl = null;
    protected ExternalID cureid = null;
    private final List<double[]> coords = new ArrayList<double[]>();
    private final List<Polygon> polys = new ArrayList<Polygon>();
    private final ArrayList<String> labels = new ArrayList();

    public SimplePolygonParser(CSVReaderFormat format) {
        super(format);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            while (this.reader.nextLineExceptComments()) {
                if (!this.parseLine()) continue;
                if (this.meta == null || this.curlbl != null && !this.haslabels) {
                    this.haslabels = this.haslabels || this.curlbl != null;
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.META_CHANGED;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    protected void buildMeta() {
        if (this.haslabels) {
            this.meta = new BundleMeta(3);
            this.meta.add(TypeUtil.POLYGON_TYPE);
            this.meta.add(TypeUtil.EXTERNALID);
            this.meta.add(TypeUtil.LABELLIST);
        } else {
            this.meta = new BundleMeta(2);
            this.meta.add(TypeUtil.POLYGON_TYPE);
            this.meta.add(TypeUtil.EXTERNALID);
        }
    }

    @Override
    public BundleMeta getMeta() {
        return this.meta;
    }

    @Override
    public Object data(int rnum) {
        if (rnum > (this.haslabels ? 2 : 1)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return rnum == 0 ? this.curpoly : (rnum == 1 ? this.cureid : this.curlbl);
    }

    private boolean parseLine() {
        this.cureid = null;
        this.curpoly = null;
        this.curlbl = null;
        this.polys.clear();
        this.coords.clear();
        this.labels.clear();
        Matcher m = COORD.matcher(this.reader.getBuffer());
        while (this.tokenizer.valid()) {
            block12: {
                m.region(this.tokenizer.getStart(), this.tokenizer.getEnd());
                if (m.find()) {
                    try {
                        double c1 = ParseUtil.parseDouble(m.group(1));
                        double c2 = ParseUtil.parseDouble(m.group(2));
                        if (m.group(3) != null) {
                            double c3 = ParseUtil.parseDouble(m.group(3));
                            this.coords.add(new double[]{c1, c2, c3});
                        } else {
                            this.coords.add(new double[]{c1, c2});
                        }
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        LOG.warning("Looked like a coordinate pair but didn't parse: " + this.tokenizer.getSubstring());
                    }
                }
                int len = this.tokenizer.getEnd() - this.tokenizer.getStart();
                if (POLYGON_SEPARATOR.length() == len && this.reader.getBuffer().subSequence(this.tokenizer.getStart(), this.tokenizer.getEnd()).equals(POLYGON_SEPARATOR)) {
                    if (!this.coords.isEmpty()) {
                        this.polys.add(new Polygon(new ArrayList<double[]>(this.coords)));
                    }
                } else {
                    String cur = this.tokenizer.getSubstring();
                    if (this.cureid == null) {
                        this.cureid = new ExternalID(cur);
                    } else {
                        this.labels.add(cur);
                    }
                }
            }
            this.tokenizer.advance();
        }
        if (!this.coords.isEmpty()) {
            this.polys.add(new Polygon(this.coords));
        }
        this.curpoly = new PolygonsObject(this.polys);
        this.curlbl = this.haslabels || !this.labels.isEmpty() ? LabelList.make(this.labels) : null;
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected SimplePolygonParser makeInstance() {
            return new SimplePolygonParser(this.format);
        }
    }
}

