/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.InputStream;

public class SimpleTransactionParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimpleTransactionParser.class);
    int numterms;
    Object2IntOpenHashMap<String> keymap;
    protected BundleMeta meta;
    BundleStreamSource.Event nextevent;
    BitVector curvec;
    LongArrayList buf = new LongArrayList();

    public SimpleTransactionParser(CSVReaderFormat format) {
        super(format);
        this.keymap = new Object2IntOpenHashMap();
        this.keymap.defaultReturnValue(-1);
    }

    @Override
    public void initStream(InputStream in) {
        super.initStream(in);
        this.nextevent = BundleStreamSource.Event.META_CHANGED;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            if (this.reader.nextLineExceptComments()) {
                this.buf.clear();
                while (this.tokenizer.valid()) {
                    String token = this.tokenizer.getSubstring();
                    int t = this.keymap.getInt(token);
                    if (t < 0) {
                        t = this.keymap.size();
                        this.keymap.put(token, t);
                    }
                    int word = t >>> 6;
                    int off = t & 0x3F;
                    while (word >= this.buf.size()) {
                        this.buf.add(0L);
                    }
                    this.buf.set(word, this.buf.getLong(word) | 1L << off);
                    this.tokenizer.advance();
                }
                this.curvec = new BitVector(this.buf.toLongArray(), this.keymap.size());
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            this.nextevent = BundleStreamSource.Event.END_OF_STREAM;
            this.meta = new BundleMeta(1);
            String[] colnames = new String[this.keymap.size()];
            ObjectIterator iter = this.keymap.object2IntEntrySet().fastIterator();
            while (iter.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                colnames[entry.getIntValue()] = (String)entry.getKey();
            }
            this.meta.add(new VectorFieldTypeInformation<BitVector>(BitVector.FACTORY, colnames.length, colnames));
            return BundleStreamSource.Event.META_CHANGED;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.curvec = null;
    }

    @Override
    public Object data(int rnum) {
        if (rnum != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.curvec;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.meta = new BundleMeta(1);
            this.meta.add(new VectorTypeInformation<BitVector>(BitVector.FACTORY, BitVector.SHORT_SERIALIZER, 0, this.numterms));
        }
        return this.meta;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected SimpleTransactionParser makeInstance() {
            return new SimpleTransactionParser(this.format);
        }
    }
}

