/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Title(value="String Parser")
@Description(value="Parses new line separated strings")
public class StringParser
implements Parser {
    Matcher comment;
    boolean trimWhitespace;

    public StringParser(Pattern comment, boolean trimWhitespace) {
        this.comment = comment != null ? comment.matcher("") : null;
        this.trimWhitespace = trimWhitespace;
    }

    @Override
    public MultipleObjectsBundle parse(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int lineNumber = 0;
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<LabelList> labels = new ArrayList<LabelList>();
        ArrayList<String> ll = new ArrayList<String>(1);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line.length() <= 0 || this.comment != null && this.comment.reset(line).matches())) {
                    String val = this.trimWhitespace ? line.trim() : line;
                    data.add(val);
                    ll.clear();
                    ll.add(val);
                    labels.add(LabelList.make(ll));
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + lineNumber + ".");
        }
        return MultipleObjectsBundle.makeSimple(TypeUtil.STRING, data, TypeUtil.LABELLIST, labels);
    }

    @Override
    public void cleanup() {
        this.comment.reset("");
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID TRIM_ID = new OptionID("string.trim", "Remove leading and trailing whitespace from each line.");
        Pattern comment = null;
        boolean trimWhitespace = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag trimP;
            super.makeOptions(config);
            PatternParameter commentP = new PatternParameter(CSVReaderFormat.Parameterizer.COMMENT_ID, "^\\s*#.*$");
            if (config.grab(commentP)) {
                this.comment = (Pattern)commentP.getValue();
            }
            if (config.grab(trimP = new Flag(TRIM_ID))) {
                this.trimWhitespace = trimP.isTrue();
            }
        }

        @Override
        protected StringParser makeInstance() {
            return new StringParser(this.comment, this.trimWhitespace);
        }
    }
}

