/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseFloatVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;

public class TermFrequencyParser<V extends SparseNumberVector>
extends NumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(TermFrequencyParser.class);
    int numterms;
    Object2IntOpenHashMap<String> keymap;
    boolean normalize;
    private SparseNumberVector.Factory<V> sparsefactory;
    Int2DoubleOpenHashMap values = new Int2DoubleOpenHashMap();
    ArrayList<String> labels = new ArrayList();

    public TermFrequencyParser(boolean normalize, SparseNumberVector.Factory<V> factory) {
        this(normalize, CSVReaderFormat.DEFAULT_FORMAT, null, factory);
    }

    public TermFrequencyParser(boolean normalize, CSVReaderFormat format, long[] labelIndices, SparseNumberVector.Factory<V> factory) {
        super(format, labelIndices, factory);
        this.normalize = normalize;
        this.keymap = new Object2IntOpenHashMap();
        this.keymap.defaultReturnValue(-1);
        this.sparsefactory = factory;
    }

    @Override
    protected boolean parseLineInternal() {
        double len = 0.0;
        String curterm = null;
        int c = 0;
        while (this.tokenizer.valid()) {
            if (this.isLabelColumn(c++)) {
                this.labels.add(this.tokenizer.getSubstring());
            } else if (curterm == null) {
                curterm = this.tokenizer.getSubstring();
            } else {
                try {
                    double attribute = this.tokenizer.getDouble();
                    int curdim = this.keymap.getInt(curterm);
                    if (curdim < 0) {
                        curdim = this.numterms++;
                        this.keymap.put(curterm, curdim);
                    }
                    this.values.put(curdim, attribute);
                    len += attribute;
                    curterm = null;
                }
                catch (NumberFormatException e) {
                    if (!(this.warnedPrecision || e != ParseUtil.PRECISION_OVERFLOW && e != ParseUtil.EXPONENT_OVERFLOW)) {
                        this.getLogger().warning("Too many digits in what looked like a double number - treating as string: " + this.tokenizer.getSubstring());
                        this.warnedPrecision = true;
                    }
                    this.labels.add(curterm);
                    curterm = this.tokenizer.getSubstring();
                }
            }
            this.tokenizer.advance();
        }
        if (curterm != null) {
            this.labels.add(curterm);
        }
        this.haslabels |= !this.labels.isEmpty();
        if (this.normalize && Math.abs(len - 1.0) > Double.MIN_NORMAL) {
            ObjectIterator<Int2DoubleMap.Entry> iter = this.values.int2DoubleEntrySet().fastIterator();
            while (iter.hasNext()) {
                Int2DoubleMap.Entry entry = (Int2DoubleMap.Entry)iter.next();
                entry.setValue(entry.getDoubleValue() / len);
            }
        }
        this.curvec = this.sparsefactory.newNumberVector(this.values, this.numterms);
        this.curlbl = LabelList.make(this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected SimpleTypeInformation<V> getTypeInformation(int mindim, int maxdim) {
        if (mindim == maxdim) {
            return new VectorFieldTypeInformation(this.factory, mindim);
        }
        if (mindim < maxdim) {
            return new VectorTypeInformation(this.factory, this.factory.getDefaultSerializer(), mindim, maxdim);
        }
        throw new AbortException("No vectors were read from the input file - cannot determine vector data type.");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Parameterizer<V> {
        public static final OptionID NORMALIZE_FLAG = new OptionID("tf.normalize", "Normalize vectors to manhattan length 1 (convert term counts to term frequencies)");
        boolean normalize = false;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag normF = new Flag(NORMALIZE_FLAG);
            if (config.grab(normF)) {
                this.normalize = normF.isTrue();
            }
        }

        @Override
        protected void getFactory(Parameterization config) {
            ObjectParameter factoryP = new ObjectParameter(VECTOR_TYPE_ID, (Class<?>)SparseNumberVector.Factory.class, SparseFloatVector.Factory.class);
            if (config.grab(factoryP)) {
                this.factory = (NumberVector.Factory)factoryP.instantiateClass(config);
            }
        }

        @Override
        protected TermFrequencyParser<V> makeInstance() {
            return new TermFrequencyParser(this.normalize, this.format, this.labelIndices, (SparseNumberVector.Factory)this.factory);
        }
    }
}

