/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@References(value={@Reference(authors="J. R. Bray, J. T. Curtis", title="An ordination of the upland forest communities of southern Wisconsin", booktitle="Ecological monographs 27.4", url="https://doi.org/10.2307/1942268", bibkey="doi:10.2307/1942268"), @Reference(authors="T. S\u00f8rensen", title="A method of establishing groups of equal amplitude in plant sociology based on similarity of species and its application to analyses of the vegetation on Danish commons", booktitle="Kongelige Danske Videnskabernes Selskab 5 (4)", bibkey="journals/misc/Sorensen48"), @Reference(authors="L. R. Dice", title="Measures of the Amount of Ecologic Association Between Species", booktitle="Ecology 26 (3)", url="https://doi.org/10.2307/1932409", bibkey="doi:10.2307/1932409")})
@Alias(value={"bray-curtis", "braycurtis", "sorensen", "dice", "sorensen-dice"})
public class BrayCurtisDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final BrayCurtisDistanceFunction STATIC_CONTINUOUS = new BrayCurtisDistanceFunction();

    @Deprecated
    public BrayCurtisDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = BrayCurtisDistanceFunction.dimensionality(v1, v2);
        double sumdiff = 0.0;
        double sumsum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            sumdiff += Math.abs(xd - yd);
            sumsum += Math.abs(xd) + Math.abs(yd);
        }
        return sumsum > 0.0 ? sumdiff / sumsum : 0.0;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = BrayCurtisDistanceFunction.dimensionality(mbr1, mbr2);
        double sumdiff = 0.0;
        double sumsum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double min1 = mbr1.getMin(d);
            double max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            sumdiff += max1 < min2 ? min2 - max1 : (min1 > max2 ? min1 - max2 : 0.0);
            sumsum += Math.max(-min1, max1) + Math.max(-min2, max2);
        }
        return sumsum > 0.0 ? sumdiff / sumsum : 0.0;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BrayCurtisDistanceFunction makeInstance() {
            return STATIC_CONTINUOUS;
        }
    }
}

