/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Priority(value=200)
@Reference(authors="G. N. Lance, W. T. Williams", title="Computer Programs for Hierarchical Polythetic Classification (Similarity Analyses)", booktitle="Computer Journal, Volume 9, Issue 1", url="https://doi.org/10.1093/comjnl/9.1.60", bibkey="doi:10.1093/comjnl/9.1.60")
@Alias(value={"canberra"})
public class CanberraDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    public static final CanberraDistanceFunction STATIC = new CanberraDistanceFunction();

    protected CanberraDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int d;
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            double div = Math.abs(xd) + Math.abs(yd);
            if (!(div > 0.0)) continue;
            agg += Math.abs(xd - yd) / div;
        }
        for (d = mindim; d < dim1; ++d) {
            if (v1.doubleValue(d) == 0.0) continue;
            agg += 1.0;
        }
        for (d = mindim; d < dim2; ++d) {
            if (v2.doubleValue(d) == 0.0) continue;
            agg += 1.0;
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int d;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double diff;
            if (mbr1.getMax(d) < mbr2.getMin(d)) {
                diff = mbr2.getMin(d) - mbr1.getMax(d);
            } else {
                if (!(mbr1.getMin(d) > mbr2.getMax(d))) continue;
                diff = mbr1.getMin(d) - mbr2.getMax(d);
            }
            double a1 = Math.max(-mbr1.getMin(d), mbr1.getMax(d));
            double a2 = Math.max(-mbr2.getMin(d), mbr2.getMax(d));
            double div = a1 + a2;
            agg += diff / div;
        }
        for (d = mindim; d < dim1; ++d) {
            if (!(mbr1.getMin(d) > 0.0) && !(mbr1.getMax(d) < 0.0)) continue;
            agg += 1.0;
        }
        for (d = mindim; d < dim2; ++d) {
            if (!(mbr2.getMin(d) > 0.0) && !(mbr2.getMax(d) < 0.0)) continue;
            agg += 1.0;
        }
        return agg;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CanberraDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

