/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Priority(value=200)
@Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")
public class ClarkDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    public static final ClarkDistanceFunction STATIC = new ClarkDistanceFunction();

    @Deprecated
    public ClarkDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int d;
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            double div = Math.abs(xd) + Math.abs(yd);
            if (!(div > 0.0)) continue;
            double v = (xd - yd) / div;
            agg += v * v;
        }
        for (d = mindim; d < dim1; ++d) {
            if (v1.doubleValue(d) == 0.0) continue;
            agg += 1.0;
        }
        for (d = mindim; d < dim2; ++d) {
            if (v2.doubleValue(d) == 0.0) continue;
            agg += 1.0;
        }
        return FastMath.sqrt(agg / (double)Math.max(dim1, dim2));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int d;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double diff;
            double min1 = mbr1.getMin(d);
            double max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            if (max1 < min2) {
                diff = min2 - max1;
            } else {
                if (!(min1 > max2)) continue;
                diff = min1 - max2;
            }
            double absmax1 = Math.max(-min1, max1);
            double absmax2 = Math.max(-min2, max2);
            double v = diff / (absmax1 + absmax2);
            agg += v * v;
        }
        for (d = mindim; d < dim1; ++d) {
            if (!(mbr1.getMin(d) > 0.0) && !(mbr1.getMax(d) < 0.0)) continue;
            agg += 1.0;
        }
        for (d = mindim; d < dim2; ++d) {
            if (!(mbr2.getMin(d) > 0.0) && !(mbr2.getMax(d) < 0.0)) continue;
            agg += 1.0;
        }
        return FastMath.sqrt(agg / (double)Math.max(dim1, dim2));
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClarkDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

