/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Priority(value=100)
@Alias(value={"cosine"})
public class CosineDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    public static final CosineDistanceFunction STATIC = new CosineDistanceFunction();

    @Deprecated
    public CosineDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        double d = VectorUtil.cosAngle(v1, v2);
        return d <= 1.0 ? 1.0 - d : 0.0;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double d = VectorUtil.minCosAngle(mbr1, mbr2);
        return d <= 1.0 ? 1.0 - d : 0.0;
    }

    public String toString() {
        return "CosineDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CosineDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

