/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedQuadraticDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="P. C. Mahalanobis", title="On the generalized distance in statistics", booktitle="Proceedings of the National Institute of Sciences of India. 2 (1)", bibkey="journals/misc/Mahalanobis36")
public class MahalanobisDistanceFunction
extends MatrixWeightedQuadraticDistanceFunction {
    public MahalanobisDistanceFunction(double[][] weightMatrix) {
        super(weightMatrix);
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        return FastMath.sqrt(super.distance(o1, o2));
    }

    @Override
    public double norm(NumberVector obj) {
        return Math.sqrt(super.norm(obj));
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public boolean isSquared() {
        return false;
    }
}

