/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;

public class MatrixWeightedQuadraticDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements Norm<NumberVector> {
    protected double[][] weightMatrix;

    public MatrixWeightedQuadraticDistanceFunction(double[][] weightMatrix) {
        this.weightMatrix = weightMatrix;
        assert (weightMatrix[0].length == weightMatrix.length);
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        int dim = MatrixWeightedQuadraticDistanceFunction.dimensionality(o1, o2, this.weightMatrix.length);
        double[] tmp = new double[dim];
        for (int i = 0; i < dim; ++i) {
            tmp[i] = o1.doubleValue(i) - o2.doubleValue(i);
        }
        return VMath.transposeTimesTimes(tmp, this.weightMatrix, tmp);
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    @Override
    public double norm(NumberVector obj) {
        double[] v = obj.toArray();
        MatrixWeightedQuadraticDistanceFunction.dimensionality(v, this.weightMatrix[0]);
        return VMath.transposeTimesTimes(v, this.weightMatrix, v);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && VMath.equals(this.weightMatrix, ((MatrixWeightedQuadraticDistanceFunction)obj).weightMatrix);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + Arrays.deepHashCode((Object[])this.weightMatrix);
    }

    @Override
    public VectorFieldTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, this.weightMatrix.length, this.weightMatrix.length);
    }
}

