/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DBIDDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDatabaseDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Random;

@Priority(value=-100)
public class RandomStableDistanceFunction
extends AbstractDatabaseDistanceFunction<DBID>
implements DBIDDistanceFunction {
    public static final RandomStableDistanceFunction STATIC = new RandomStableDistanceFunction(new Random().nextLong());
    private long seed;

    public RandomStableDistanceFunction(long seed) {
        this.seed = seed;
    }

    @Override
    public double distance(DBIDRef o1, DBIDRef o2) {
        int c = DBIDUtil.compare(o1, o2);
        if (c == 0) {
            return 0.0;
        }
        if (c > 0) {
            return this.distance(o2, o1);
        }
        return this.pseudoRandom(this.seed, Util.mixHashCodes(DBIDUtil.asInteger(o1), DBIDUtil.asInteger(o2), (int)this.seed));
    }

    private double pseudoRandom(long seed, int input) {
        long mult = 25214903917L;
        long add = 11L;
        long mask = 0xFFFFFFFFFFFFL;
        long i1 = ((long)input ^ seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long i2 = ((long)input ^ seed >>> 16 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long l1 = i1 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        long l2 = i2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        int r1 = (int)(l1 >>> 22);
        int r2 = (int)(l2 >>> 21);
        double random = (double)(((long)r1 << 27) + (long)r2) / 9.007199254740992E15;
        return random;
    }

    public String toString() {
        return "RandomDistance";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.seed == ((RandomStableDistanceFunction)obj).seed;
    }

    public int hashCode() {
        return (int)this.seed;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.DBID;
    }

    @Override
    public <T extends DBID> DistanceQuery<T> instantiate(Relation<T> relation) {
        return new DBIDDistanceQuery(relation, this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RandomStableDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

