/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractIndexBasedDistanceFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public class SharedNearestNeighborJaccardDistanceFunction<O>
extends AbstractIndexBasedDistanceFunction<O, SharedNearestNeighborIndex.Factory<O>> {
    public SharedNearestNeighborJaccardDistanceFunction(SharedNearestNeighborIndex.Factory<O> indexFactory) {
        super(indexFactory);
    }

    @Override
    public <T extends O> Instance<T> instantiate(Relation<T> database) {
        Index indexi = ((SharedNearestNeighborIndex.Factory)this.indexFactory).instantiate((Relation)database);
        return new Instance<T>(database, indexi, this);
    }

    public static class Parameterizer<O>
    extends AbstractIndexBasedDistanceFunction.Parameterizer<SharedNearestNeighborIndex.Factory<O>> {
        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.configIndexFactory(config, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        @Override
        protected SharedNearestNeighborJaccardDistanceFunction<O> makeInstance() {
            return new SharedNearestNeighborJaccardDistanceFunction((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedDistanceFunction.Instance<T, SharedNearestNeighborIndex<T>, SharedNearestNeighborJaccardDistanceFunction<T>> {
        public Instance(Relation<T> database, SharedNearestNeighborIndex<T> preprocessor, SharedNearestNeighborJaccardDistanceFunction<T> parent) {
            super(database, preprocessor, parent);
        }

        protected static double jaccardCoefficient(DBIDs neighbors1, DBIDs neighbors2) {
            int intersection = 0;
            int union = 0;
            DBIDIter iter1 = neighbors1.iter();
            DBIDIter iter2 = neighbors2.iter();
            while (iter1.valid() && iter2.valid()) {
                int comp = DBIDUtil.compare(iter1, iter2);
                ++union;
                if (comp == 0) {
                    ++intersection;
                    iter1.advance();
                    iter2.advance();
                    continue;
                }
                if (comp < 0) {
                    iter1.advance();
                    continue;
                }
                iter2.advance();
            }
            while (iter1.valid()) {
                ++union;
                iter1.advance();
            }
            while (iter2.valid()) {
                ++union;
                iter2.advance();
            }
            return (double)intersection / (double)union;
        }

        @Override
        public double distance(DBIDRef id1, DBIDRef id2) {
            ArrayDBIDs neighbors1 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id1);
            ArrayDBIDs neighbors2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id2);
            return 1.0 - Instance.jaccardCoefficient(neighbors1, neighbors2);
        }
    }
}

